/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.uwrad.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static final boolean ENFORCE_SAFE_WORLD_RANDOM_ACCESS;

    public static void init() {
    }

    private static int getInt(Properties properties, Properties newProperties, String key, int def) {
        try {
            int i = Integer.parseInt(properties.getProperty(key));
            newProperties.setProperty(key, String.valueOf(i));
            return i;
        }
        catch (NumberFormatException e) {
            newProperties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private static boolean getBoolean(Properties properties, Properties newProperties, String key, boolean def) {
        try {
            boolean b = Config.parseBoolean(properties.getProperty(key));
            newProperties.setProperty(key, String.valueOf(b));
            return b;
        }
        catch (NumberFormatException e) {
            newProperties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private static boolean parseBoolean(String string) {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (string.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (string.trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new NumberFormatException(string);
    }

    static {
        Properties properties = new Properties();
        Properties newProperties = new Properties();
        Path path = FabricLoader.getInstance().getConfigDir().resolve("uwrad.properties");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, StandardOpenOption.CREATE);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ENFORCE_SAFE_WORLD_RANDOM_ACCESS = Config.getBoolean(properties, newProperties, "enforce_safe_world_random_access", true);
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            newProperties.store(out, "Configuration file for unsafe-world-random-access-detector");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

