/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import fuzs.forgeconfigscreens.client.gui.screens.ConfigScreen;
import fuzs.forgeconfigscreens.client.gui.widget.ConfigEditBox;
import fuzs.forgeconfigscreens.client.gui.widget.MutableIconButton;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class EditListScreen
extends class_437 {
    private final class_437 lastScreen;
    private final List<MutableObject<String>> values;
    private final Predicate<String> validator;
    private final Consumer<List<String>> onSave;
    private final Set<EditEntry> invalidEntries = Sets.newHashSet();
    private EditList list;
    private class_4185 doneButton;
    @Nullable
    private ConfigEditBox activeTextField;
    @Nullable
    private List<? extends class_5481> activeTooltip;
    private int tooltipTicks;

    public EditListScreen(class_437 lastScreen, class_2561 title, List<String> listValue, Predicate<String> validator, Consumer<List<String>> onSave) {
        super(title);
        this.lastScreen = lastScreen;
        this.values = listValue.stream().map(MutableObject::new).collect(Collectors.toList());
        this.validator = validator;
        this.onSave = onSave;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    protected void method_25426() {
        this.list = new EditList(this.values);
        this.method_25429((class_364)this.list);
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.onSave.accept(this.values.stream().map(MutableObject::getValue).collect(Collectors.toList()));
            this.field_22787.method_1507(this.lastScreen);
        }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.field_22787.method_1507(this.lastScreen)).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431());
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List<? extends class_5481> lastTooltip = this.activeTooltip;
        this.activeTooltip = null;
        this.method_25420(guiGraphics);
        this.list.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 14, 0xFFFFFF);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != lastTooltip) {
            this.tooltipTicks = 0;
        }
        if (this.activeTooltip != null && this.tooltipTicks >= 10) {
            guiGraphics.method_51447(this.field_22793, this.activeTooltip, mouseX, mouseY);
        }
    }

    public void method_25393() {
        if (this.activeTextField != null) {
            this.activeTextField.method_1865();
        }
        if (this.tooltipTicks < 10) {
            ++this.tooltipTicks;
        }
    }

    private void updateDoneButton() {
        if (this.doneButton != null) {
            this.doneButton.field_22763 = this.invalidEntries.isEmpty();
        }
    }

    void markInvalid(EditEntry entry) {
        this.invalidEntries.add(entry);
        this.updateDoneButton();
    }

    void clearInvalid(EditEntry entry) {
        this.invalidEntries.remove((Object)entry);
        this.updateDoneButton();
    }

    public class EditList
    extends class_4265<EditListEntry> {
        public EditList(List<MutableObject<String>> values) {
            super(EditListScreen.this.field_22787, EditListScreen.this.field_22789, EditListScreen.this.field_22790, 36, EditListScreen.this.field_22790 - 36, 24);
            values.forEach(value -> this.method_25321((class_350.class_351)new EditEntry(this, (MutableObject<String>)value)));
            this.method_25321((class_350.class_351)new AddEntry(this, values));
        }

        protected int method_25329() {
            return this.field_22742 / 2 + 144;
        }

        public int method_25322() {
            return 260;
        }

        protected int addEntry(int index, EditListEntry entry) {
            this.method_25396().add(index, entry);
            return this.method_25396().size() - 1;
        }

        protected boolean removeEntry(EditListEntry entry) {
            return super.method_25330((class_350.class_351)entry);
        }
    }

    private class EditEntry
    extends EditListEntry {
        private final MutableObject<String> holder;
        private final ConfigEditBox textField;
        private final class_4185 deleteButton;

        public EditEntry(EditList list, MutableObject<String> holder) {
            this(list, holder, false);
        }

        public EditEntry(EditList list, MutableObject<String> holder, boolean withFocus) {
            this.holder = holder;
            this.textField = new ConfigEditBox(EditListScreen.this.field_22793, 0, 0, 236, 18, () -> EditListScreen.this.activeTextField, activeTextField -> {
                EditListScreen.this.activeTextField = activeTextField;
            }){

                @Override
                public void method_25365(boolean focused) {
                    super.method_25365(focused);
                    EditListScreen.this.activeTextField = focused ? this : null;
                }
            };
            this.textField.method_1863(input -> {
                if (EditListScreen.this.validator.test((String)input)) {
                    this.textField.markInvalid(false);
                    this.holder.setValue(input);
                    EditListScreen.this.clearInvalid(this);
                } else {
                    this.textField.markInvalid(true);
                    EditListScreen.this.markInvalid(this);
                }
            });
            this.textField.method_1880(32500);
            this.textField.method_1852((String)holder.getValue());
            this.textField.method_25365(withFocus);
            final List tooltip = ((EditListScreen)EditListScreen.this).field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)"configmenusforge.gui.tooltip.remove"), 200);
            this.deleteButton = new MutableIconButton(0, 0, 20, 20, 100, 0, ConfigScreen.ICONS_LOCATION, button -> {
                EditListScreen.this.values.remove(holder);
                list.removeEntry(this);
                EditListScreen.this.clearInvalid(this);
            }){

                @Override
                public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
                    if (this.field_22763) {
                        EditListScreen.this.activeTooltip = tooltip;
                    }
                }
            };
        }

        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.textField.method_46421(entryLeft);
            this.textField.method_46419(entryTop + 1);
            this.textField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            this.deleteButton.method_46421(entryLeft + rowWidth - 21);
            this.deleteButton.method_46419(entryTop);
            this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.textField), (Object)this.deleteButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37033(class_6381.field_33788, (String)EditEntry.this.holder.getValue());
                }
            }, (Object)((Object)this.textField), (Object)this.deleteButton);
        }
    }

    private class AddEntry
    extends EditListEntry {
        private final class_4185 addButton;

        public AddEntry(EditList list, List<MutableObject<String>> values) {
            final List tooltip = ((EditListScreen)EditListScreen.this).field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)"configmenusforge.gui.tooltip.add"), 200);
            this.addButton = new MutableIconButton(0, 0, 20, 20, 80, 0, ConfigScreen.ICONS_LOCATION, button -> {
                MutableObject holder = new MutableObject((Object)"");
                values.add(holder);
                list.addEntry(list.method_25396().size() - 1, new EditEntry(list, (MutableObject<String>)holder, true));
            }){

                @Override
                public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
                    if (this.field_22763) {
                        EditListScreen.this.activeTooltip = tooltip;
                    }
                }
            };
        }

        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.addButton.method_46421(entryLeft + rowWidth - 21);
            this.addButton.method_46419(entryTop);
            this.addButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.addButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                }
            }, (Object)this.addButton);
        }
    }

    public static abstract class EditListEntry
    extends class_4265.class_4266<EditListEntry> {
    }
}

