/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.data;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Iterators;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.gui.helper.ScreenTextHelper;
import fuzs.forgeconfigscreens.client.gui.screens.ConfigScreen;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class EntryData
implements IEntryData {
    private final String path;
    private final String comment;
    private final class_2561 title;

    EntryData(String path, String comment, class_2561 title) {
        this.path = path;
        this.comment = comment;
        this.title = title;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public boolean mayResetValue() {
        return false;
    }

    @Override
    public boolean mayDiscardChanges() {
        return true;
    }

    @Override
    public void resetCurrentValue() {
    }

    @Override
    public void discardCurrentValue() {
    }

    @Override
    public void saveConfigValue() {
    }

    @Override
    public boolean category() {
        return false;
    }

    public static class ConfigEntryData<T>
    extends EntryData {
        private final ForgeConfigSpec.ConfigValue<T> configValue;
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private T currentValue;

        public ConfigEntryData(String path, ForgeConfigSpec.ConfigValue<T> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(path, valueSpec.getComment(), ConfigEntryData.createLabel(path, configValue, valueSpec));
            this.configValue = configValue;
            this.valueSpec = valueSpec;
            this.currentValue = configValue.get();
        }

        @Override
        public boolean mayResetValue() {
            return !ConfigEntryData.listSafeEquals(this.currentValue, this.getDefaultValue());
        }

        @Override
        public boolean mayDiscardChanges() {
            return ConfigEntryData.listSafeEquals(this.configValue.get(), this.currentValue);
        }

        private static <T> boolean listSafeEquals(T o1, T o2) {
            if (o1 instanceof List) {
                List list1 = (List)o1;
                if (o2 instanceof List) {
                    List list2 = (List)o2;
                    Stream<String> stream1 = list1.stream().map(o -> {
                        String string;
                        if (o instanceof Enum) {
                            Enum e = (Enum)o;
                            string = e.name();
                        } else {
                            string = o.toString();
                        }
                        return string;
                    });
                    Stream<String> stream2 = list2.stream().map(o -> {
                        String string;
                        if (o instanceof Enum) {
                            Enum e = (Enum)o;
                            string = e.name();
                        } else {
                            string = o.toString();
                        }
                        return string;
                    });
                    return Iterators.elementsEqual(stream1.iterator(), stream2.iterator());
                }
            }
            return o1.equals(o2);
        }

        @Override
        public void resetCurrentValue() {
            this.currentValue = this.getDefaultValue();
        }

        @Override
        public void discardCurrentValue() {
            this.currentValue = this.configValue.get();
        }

        @Override
        public void saveConfigValue() {
            this.configValue.set(this.currentValue);
        }

        public T getDefaultValue() {
            return (T)this.valueSpec.getDefault();
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(T currentValue) {
            this.currentValue = currentValue;
        }

        public ForgeConfigSpec.ValueSpec getValueSpec() {
            return this.valueSpec;
        }

        public List<String> getFullPath() {
            return this.configValue.getPath();
        }

        private static class_2561 createLabel(String path, ForgeConfigSpec.ConfigValue<?> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            if (valueSpec.getTranslationKey() != null && class_1074.method_4663((String)valueSpec.getTranslationKey())) {
                return class_2561.method_43471((String)valueSpec.getTranslationKey());
            }
            return ScreenTextHelper.toFormattedComponent(path);
        }
    }

    public static class CategoryEntryData
    extends EntryData {
        private final UnmodifiableConfig config;
        private ConfigScreen screen;

        public CategoryEntryData(String path, UnmodifiableConfig config, String comment) {
            super(path, comment, ScreenTextHelper.toFormattedComponent(path));
            this.config = config;
        }

        public UnmodifiableConfig getConfig() {
            return this.config;
        }

        public ConfigScreen getScreen() {
            return this.screen;
        }

        public void setScreen(ConfigScreen screen) {
            this.screen = screen;
        }

        @Override
        public boolean category() {
            return true;
        }
    }
}

