/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.gui.screens.ConfigScreen;
import fuzs.forgeconfigscreens.client.gui.screens.SelectConfigScreen;
import fuzs.forgeconfigscreens.client.gui.screens.SelectConfigWorldScreen;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_327;
import net.minecraft.class_33;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7413;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigSelectionList
extends class_4280<Entry> {
    private static final class_2960 ICON_LOCATION = ForgeConfigScreens.id("textures/misc/config.png");
    private static final class_2960 ICON_DISABLED_LOCATION = ForgeConfigScreens.id("textures/misc/disabled_config.png");
    private static final class_2960 ICON_OVERLAY_LOCATION = new class_2960("textures/gui/world_selection.png");
    private static final class_2561 SELECT_WORLD_TOOLTIP = class_2561.method_43471((String)"configmenusforge.gui.select.select_world").method_27692(class_124.field_1065);
    private static final class_2561 NO_DATA_TOOLTIP = class_2561.method_43471((String)"configmenusforge.gui.select.no_data").method_27692(class_124.field_1061);
    private static final class_2561 NO_PERMISSIONS_TOOLTIP = class_2561.method_43471((String)"configmenusforge.gui.select.no_permissions").method_27692(class_124.field_1065);
    private static final class_2561 MULTIPLAYER_SERVER_TOOLTIP = class_2561.method_43471((String)"configmenusforge.gui.select.multiplayer_server").method_27692(class_124.field_1065);
    private final SelectConfigScreen screen;
    private final Entry loadingHeader;
    private final CompletableFuture<List<class_34>> pendingLevels;
    private List<class_34> levelList;
    private String filter;

    public ConfigSelectionList(SelectConfigScreen selectConfigScreen, class_310 minecraft, int width, int height, int y0, int y1, int itemHeight, String filter, @Nullable ConfigSelectionList list) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = selectConfigScreen;
        this.filter = filter;
        this.loadingHeader = new LoadingHeader(this.field_22740);
        this.pendingLevels = list != null ? list.pendingLevels : this.loadLevels();
        this.handleNewLevels(this.pollLevelsIgnoreErrors());
    }

    private static boolean matchesConfigSearch(ModConfig config, String query) {
        if (config.getFileName().toLowerCase(Locale.ROOT).contains(query)) {
            return true;
        }
        return config.getType().extension().contains(query);
    }

    public void updateFilter(String filter) {
        if (this.levelList != null && !filter.equals(this.filter)) {
            this.fillLevels(filter);
        }
        this.filter = filter;
    }

    private CompletableFuture<List<class_34>> loadLevels() {
        class_32.class_7410 levelCandidates;
        if (this.field_22740.method_1562() == null) {
            try {
                levelCandidates = this.field_22740.method_1586().method_235();
            }
            catch (class_33 var3) {
                ForgeConfigScreens.LOGGER.error("Couldn't load level list", (Throwable)var3);
                return CompletableFuture.completedFuture(List.of());
            }
        } else {
            return CompletableFuture.completedFuture(List.of());
        }
        if (levelCandidates.method_43421()) {
            return CompletableFuture.completedFuture(List.of());
        }
        return this.field_22740.method_1586().method_43417(levelCandidates).exceptionally(throwable -> {
            this.field_22740.method_1494(class_128.method_560((Throwable)throwable, (String)"Couldn't load level list"));
            return List.of();
        });
    }

    @Nullable
    private List<class_34> pollLevelsIgnoreErrors() {
        try {
            return this.pendingLevels.getNow(null);
        }
        catch (CancellationException | CompletionException e) {
            return null;
        }
    }

    private void handleNewLevels(@Nullable List<class_34> list) {
        if (list == null) {
            this.fillLoadingLevels();
        } else {
            this.fillLevels(this.filter);
        }
        this.levelList = list;
    }

    private void fillLoadingLevels() {
        this.method_25339();
        this.method_25321((class_350.class_351)this.loadingHeader);
        this.notifyListUpdated();
    }

    private void fillLevels(String filter) {
        this.method_25339();
        filter = filter.toLowerCase(Locale.ROOT).trim();
        ArrayList<ModConfig> toSort = new ArrayList<ModConfig>();
        for (ModConfig config2 : this.screen.getConfigs()) {
            if (!ConfigSelectionList.matchesConfigSearch(config2, filter)) continue;
            toSort.add(config2);
        }
        toSort.sort(Comparator.comparing(config -> config.getType().extension()).thenComparing(ConfigListEntry::getName));
        for (ModConfig config2 : toSort) {
            this.method_25321((class_350.class_351)new ConfigListEntry(this.screen, this.field_22740, config2));
        }
        this.notifyListUpdated();
    }

    private void notifyListUpdated() {
        this.screen.method_37064(true);
    }

    private void updateLevelList() {
        List<class_34> list = this.pollLevelsIgnoreErrors();
        if (list != this.levelList) {
            this.handleNewLevels(list);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        this.updateLevelList();
        super.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
    }

    protected int method_25329() {
        return this.field_22742 / 2 + 144;
    }

    public int method_25322() {
        return 260;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public void setSelected(@Nullable Entry configListEntry) {
        super.method_25313((class_350.class_351)configListEntry);
        this.screen.updateButtonStatus(configListEntry != null && configListEntry.isSelectable());
    }

    public static class LoadingHeader
    extends Entry {
        private static final class_2561 LOADING_LABEL = class_2561.method_43471((String)"selectWorld.loading_list");
        private final class_310 minecraft;

        public LoadingHeader(class_310 minecraft) {
            this.minecraft = minecraft;
        }

        public void method_25343(class_332 guiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            int i = (this.minecraft.field_1755.field_22789 - this.minecraft.field_1772.method_27525((class_5348)LOADING_LABEL)) / 2;
            int j = pTop + (pHeight - 9) / 2;
            guiGraphics.method_27535(this.minecraft.field_1772, LOADING_LABEL, i, j, 0xFFFFFF);
            String s = class_7413.method_43449((long)class_156.method_658());
            int k = (this.minecraft.field_1755.field_22789 - this.minecraft.field_1772.method_1727(s)) / 2;
            int l = j + 9;
            guiGraphics.method_25303(this.minecraft.field_1772, s, k, l, 0x808080);
        }

        public class_2561 method_37006() {
            return LOADING_LABEL;
        }

        @Override
        public boolean isSelectable() {
            return false;
        }
    }

    public static abstract class Entry
    extends class_4280.class_4281<Entry> {
        public abstract boolean isSelectable();
    }

    public class ConfigListEntry
    extends Entry {
        private final SelectConfigScreen screen;
        private final class_310 minecraft;
        private final ModConfig config;
        private final boolean mayResetValue;
        private final class_2561 nameComponent;
        private final class_2561 fileNameComponent;
        private final class_2561 typeComponent;
        private long lastClickTime;

        public ConfigListEntry(SelectConfigScreen selectConfigScreen, class_310 minecraft, ModConfig config) {
            this.screen = selectConfigScreen;
            this.minecraft = minecraft;
            this.config = config;
            this.mayResetValue = selectConfigScreen.getValueToDataMap(config).values().stream().anyMatch(IEntryData::mayResetValue);
            this.nameComponent = this.mayResetValue ? class_2561.method_43470((String)ConfigListEntry.getName(config)).method_27692(class_124.field_1056) : class_2561.method_43470((String)ConfigListEntry.getName(config));
            this.fileNameComponent = class_2561.method_43470((String)config.getFileName());
            String extension = config.getType().extension();
            this.typeComponent = class_2561.method_43469((String)"configmenusforge.gui.type.title", (Object[])new Object[]{StringUtils.capitalize((String)extension)});
        }

        static String getName(ModConfig config) {
            String fullName = config.getFileName();
            int start = fullName.lastIndexOf(File.separator) + 1;
            int end = fullName.lastIndexOf(".");
            return fullName.substring(start, end < start ? fullName.length() : end);
        }

        public class_2561 method_37006() {
            class_5250 component = class_2561.method_43470((String)ConfigListEntry.getName(this.config));
            if (this.invalidData()) {
                component = class_5244.method_37111((class_2561[])new class_2561[]{component, NO_DATA_TOOLTIP});
            } else if (this.noPermissions()) {
                component = class_5244.method_37111((class_2561[])new class_2561[]{component, NO_PERMISSIONS_TOOLTIP});
            }
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{component});
        }

        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            class_327 font = this.minecraft.field_1772;
            guiGraphics.method_27535(this.minecraft.field_1772, this.nameComponent, entryLeft + 32 + 3, entryTop + 1, 0xFFFFFF);
            guiGraphics.method_27535(this.minecraft.field_1772, this.fileNameComponent, entryLeft + 32 + 3, entryTop + 9 + 3, 0x808080);
            guiGraphics.method_27535(this.minecraft.field_1772, this.typeComponent, entryLeft + 32 + 3, entryTop + 9 + 9 + 3, 0x808080);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            guiGraphics.method_25290(this.isDisabled() ? ICON_DISABLED_LOCATION : ICON_LOCATION, entryLeft, entryTop, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                int textureY;
                guiGraphics.method_25294(entryLeft, entryTop, entryLeft + 32, entryTop + 32, -1601138544);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean leftHovered = mouseX - entryLeft < 32;
                int n = textureY = leftHovered ? 32 : 0;
                if (this.needsWorldInstance()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 32.0f, (float)textureY, 32, 32, 256, 256);
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_1772.method_1728((class_5348)SELECT_WORLD_TOOLTIP, 200));
                    }
                } else if (this.invalidData()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 96.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_1772.method_1728((class_5348)NO_DATA_TOOLTIP, 200));
                    }
                } else if (this.noPermissions()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_1772.method_1728((class_5348)NO_PERMISSIONS_TOOLTIP, 200));
                    }
                } else if (this.onMultiplayerServer()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 32.0f, (float)textureY, 32, 32, 256, 256);
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_1772.method_1728((class_5348)MULTIPLAYER_SERVER_TOOLTIP, 200));
                    }
                } else {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 0.0f, (float)textureY, 32, 32, 256, 256);
                }
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.isDisabled()) {
                return true;
            }
            ConfigSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(ConfigSelectionList.this.method_25334() != null);
            if (mouseX - (double)ConfigSelectionList.this.method_25342() <= 32.0) {
                this.openConfig();
                return true;
            }
            if (class_156.method_658() - this.lastClickTime < 250L) {
                this.openConfig();
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return false;
        }

        public void openConfig() {
            if (this.needsWorldInstance()) {
                this.selectWorld();
            } else {
                ConfigScreen screen = ConfigScreen.create(this.screen, this.screen.getDisplayName(), this.config, this.screen.getValueToDataMap(this.config));
                this.minecraft.method_1507((class_437)screen);
            }
        }

        private void selectWorld() {
            SelectConfigWorldScreen screen = new SelectConfigWorldScreen(this.screen, this.screen.getDisplayName(), this.config, ConfigSelectionList.this.levelList);
            this.minecraft.method_1507((class_437)screen);
        }

        public boolean invalidData() {
            return this.screen.getValueToDataMap(this.config).isEmpty();
        }

        public boolean needsWorldInstance() {
            return !ConfigSelectionList.this.levelList.isEmpty() && this.config.getType() == ModConfig.Type.SERVER && this.minecraft.method_1562() == null;
        }

        private boolean noPermissions() {
            return this.config.getType() == ModConfig.Type.SERVER && !this.screen.getServerPermissions();
        }

        public boolean onMultiplayerServer() {
            return this.config.getType() == ModConfig.Type.SERVER && !this.minecraft.method_1542();
        }

        boolean isDisabled() {
            return !this.needsWorldInstance() && (this.invalidData() || this.noPermissions());
        }

        public ModConfig getConfig() {
            return this.config;
        }

        public boolean mayResetValue() {
            return this.mayResetValue;
        }

        @Override
        public boolean isSelectable() {
            return !this.isDisabled();
        }
    }
}

