/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.util;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import fuzs.forgeconfigapiport.impl.config.ForgeConfigApiPortConfig;
import fuzs.forgeconfigapiport.impl.core.CommonAbstractions;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.io.FilenameUtils;

public class ConfigLoadingHelper {
    public static final Map<String, Map<String, Object>> DEFAULT_CONFIG_VALUES = Maps.newConcurrentMap();

    public static void tryLoadConfigFile(FileConfig configData) {
        ConfigLoadingHelper.tryLoadConfigFile(configData, () -> (Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("recreateConfigsWhenParsingFails"));
    }

    private static void tryLoadConfigFile(FileConfig configData, BooleanSupplier recreate) {
        try {
            configData.load();
        }
        catch (ParsingException e) {
            if (recreate.getAsBoolean()) {
                try {
                    ConfigLoadingHelper.backUpConfig(configData.getNioPath(), 5);
                    Files.delete(configData.getNioPath());
                    configData.load();
                    ForgeConfigAPIPort.LOGGER.warn("Configuration file {} could not be parsed. Correcting", (Object)configData.getNioPath());
                    return;
                }
                catch (Throwable t) {
                    e.addSuppressed(t);
                }
            }
            throw e;
        }
    }

    public static void tryRegisterDefaultConfig(ModConfig modConfig) {
        if (!((Boolean)ForgeConfigApiPortConfig.INSTANCE.getValue("correctConfigValuesFromDefaultConfig")).booleanValue()) {
            return;
        }
        String fileName = modConfig.getFileName();
        Path path = CommonAbstractions.INSTANCE.getDefaultConfigsDirectory().resolve(fileName);
        if (Files.exists(path, new LinkOption[0])) {
            try (CommentedFileConfig config = CommentedFileConfig.of(path);){
                config.load();
                Map<String, Object> values = config.valueMap();
                if (values != null && !values.isEmpty()) {
                    DEFAULT_CONFIG_VALUES.put(fileName.intern(), (Map<String, Object>)ImmutableMap.copyOf(values));
                }
                ForgeConfigAPIPort.LOGGER.debug("Loaded default config values for future corrections from file at path {}", (Object)path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void backUpConfig(Path commentedFileConfig, int maxBackups) {
        if (!Files.exists(commentedFileConfig, new LinkOption[0])) {
            return;
        }
        Path bakFileLocation = commentedFileConfig.getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFileName().toString());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFileName().toString()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig, bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            ForgeConfigAPIPort.LOGGER.warn("Failed to back up config file {}", (Object)commentedFileConfig, (Object)exception);
        }
    }
}

