/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import dev.wuffs.bcc.Config;
import dev.wuffs.bcc.Constants;
import dev.wuffs.bcc.Metadata;
import dev.wuffs.bcc.ModConfig;
import dev.wuffs.bcc.data.BetterStatus;
import dev.wuffs.bcc.data.BetterStatusServerHolder;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class BCCFabric
implements ModInitializer {
    public static ModConfig config;

    public void onInitialize() {
        Constants.LOG.info("Better Compatibility Checker starting");
        config = Config.load();
        if (config != null) {
            Constants.LOG.info("Config file loaded");
            if (BCCFabric.config.useMetadata) {
                Path metaFile = FabricLoader.getInstance().getConfigDir().resolve("metadata.json");
                if (!Files.exists(metaFile, new LinkOption[0])) {
                    Constants.LOG.error("No metadata.json found, falling back to config values");
                } else {
                    try {
                        Constants.LOG.info("Loading metadata.json");
                        Metadata metadata = (Metadata)new Gson().fromJson((Reader)Files.newBufferedReader(metaFile), Metadata.class);
                        BetterStatusServerHolder.INSTANCE.setStatus(new BetterStatus(metadata.id, metadata.name, metadata.version.name, metadata.version.id, metadata.version.type, true));
                        return;
                    }
                    catch (IOException e) {
                        Constants.LOG.error("Failed to read metadata.json", (Throwable)e);
                    }
                }
            }
            BetterStatusServerHolder.INSTANCE.setStatus(new BetterStatus(BCCFabric.config.projectID, BCCFabric.config.modpackName, BCCFabric.config.modpackVersion, -1, "unknown", false));
        } else {
            Constants.LOG.error("Failed to load config, disabling mod");
        }
    }
}

