/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.ClientPartyAllyInfo;
import xaero.pac.client.parties.party.api.IClientPartyAPI;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPartyAllyPacket
extends LazyPacket<ClientboundPartyAllyPacket> {
    public static final LazyPacket.Encoder<ClientboundPartyAllyPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final Action action;
    private final ClientPartyAllyInfo allyInfo;

    public ClientboundPartyAllyPacket(Action action, ClientPartyAllyInfo allyInfo) {
        this.action = action;
        this.allyInfo = allyInfo;
    }

    @Override
    protected Function<class_2540, ClientboundPartyAllyPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(class_2540 u) {
        class_2487 tag = new class_2487();
        tag.method_25927("i", this.allyInfo.getAllyId());
        tag.method_10582("n", this.allyInfo.getAllyName());
        tag.method_10582("dn", this.allyInfo.getAllyDefaultName());
        tag.method_10582("a", this.action.toString());
        u.method_10794(tag);
    }

    public String toString() {
        return String.format("[%s, %s, %s]", new Object[]{this.action, this.allyInfo.getAllyName(), this.allyInfo.getAllyDefaultName()});
    }

    public static enum Action {
        ADD,
        REMOVE,
        UPDATE;

    }

    public static class Decoder
    implements Function<class_2540, ClientboundPartyAllyPacket> {
        @Override
        public ClientboundPartyAllyPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 102400) {
                    return null;
                }
                class_2487 tag = input.method_30617();
                if (tag == null) {
                    return null;
                }
                UUID allyId = tag.method_25926("i");
                String allyName = tag.method_10558("n");
                if (allyName.length() > 512) {
                    return null;
                }
                String allyDefaultName = tag.method_10558("dn");
                if (allyDefaultName.length() > 512) {
                    return null;
                }
                String actionString = tag.method_10558("a");
                if (actionString.isEmpty() || actionString.length() > 128) {
                    return null;
                }
                Action action = Action.valueOf(actionString);
                return new ClientboundPartyAllyPacket(action, new ClientPartyAllyInfo(allyId, allyName, allyDefaultName));
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundPartyAllyPacket> {
        @Override
        public void handle(ClientboundPartyAllyPacket t) {
            IClientPartyAPI party = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty();
            if (party == null) {
                return;
            }
            if (t.action == Action.ADD) {
                party.addAllyParty(t.allyInfo.getAllyId());
            } else {
                party.removeAllyParty(t.allyInfo.getAllyId());
            }
            if (t.action == Action.UPDATE) {
                party.addAllyParty(t.allyInfo.getAllyId());
            }
            if (t.action == Action.REMOVE) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getAllyInfoStorage().remove(t.allyInfo.getAllyId());
            } else {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getAllyInfoStorage().add(t.allyInfo);
            }
        }
    }
}

