/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.init;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.events.lifecycle.AddSpawnBiomeModificationsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.friendsandfoes.common.init.registry.RegistryEntry;
import com.faboslav.friendsandfoes.common.init.registry.ResourcefulRegistries;
import com.faboslav.friendsandfoes.common.init.registry.ResourcefulRegistry;
import com.faboslav.friendsandfoes.common.platform.CustomSpawnGroup;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_155;
import net.minecraft.class_2902;
import net.minecraft.class_3732;
import net.minecraft.class_7923;

public final class FriendsAndFoesEntityTypes {
    public static final ResourcefulRegistry<class_1299<?>> ENTITY_TYPES = ResourcefulRegistries.create(class_7923.field_41177, "friendsandfoes");
    public static boolean previousUseChoiceTypeRegistrations = class_155.field_25135;
    public static final RegistryEntry<class_1299<CopperGolemEntity>> COPPER_GOLEM;
    public static final RegistryEntry<class_1299<CrabEntity>> CRAB;
    public static final RegistryEntry<class_1299<GlareEntity>> GLARE;
    public static final RegistryEntry<class_1299<IceologerEntity>> ICEOLOGER;
    public static final RegistryEntry<class_1299<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final RegistryEntry<class_1299<MaulerEntity>> MAULER;
    public static final RegistryEntry<class_1299<MoobloomEntity>> MOOBLOOM;
    public static final RegistryEntry<class_1299<RascalEntity>> RASCAL;
    public static final RegistryEntry<class_1299<TuffGolemEntity>> TUFF_GOLEM;
    public static final RegistryEntry<class_1299<WildfireEntity>> WILDFIRE;
    public static final RegistryEntry<class_1299<PlayerIllusionEntity>> PLAYER_ILLUSION;

    public static void registerEntityAttributes(RegisterEntityAttributesEvent event) {
        event.register(COPPER_GOLEM.get(), CopperGolemEntity.createCopperGolemAttributes());
        event.register(CRAB.get(), CrabEntity.createCrabAttributes());
        event.register(GLARE.get(), GlareEntity.createGlareAttributes());
        event.register(ICEOLOGER.get(), IceologerEntity.createIceologerAttributes());
        event.register(MAULER.get(), MaulerEntity.createMaulerAttributes());
        event.register(MOOBLOOM.get(), MoobloomEntity.method_26883());
        event.register(RASCAL.get(), RascalEntity.createRascalAttributes());
        event.register(TUFF_GOLEM.get(), TuffGolemEntity.createTuffGolemAttributes());
        event.register(WILDFIRE.get(), WildfireEntity.createWildfireAttributes());
        event.register(PLAYER_ILLUSION.get(), PlayerIllusionEntity.method_26828());
    }

    public static void registerEntitySpawnRestrictions(RegisterEntitySpawnRestrictionsEvent event) {
        event.register(CRAB.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, CrabEntity::canSpawn);
        event.register(GLARE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, GlareEntity::canSpawn);
        event.register(ICEOLOGER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        event.register(MAULER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MaulerEntity::canSpawn);
        event.register(MOOBLOOM.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MoobloomEntity::canSpawn);
        event.register(RASCAL.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, RascalEntity::canSpawn);
    }

    public static void addSpawnBiomeModifications(AddSpawnBiomeModificationsEvent event) {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableCrab && config.enableCrabSpawn) {
            event.add(FriendsAndFoesTags.HAS_CRAB, class_1311.field_6294, CRAB.get(), config.crabSpawnWeight, config.crabSpawnMinGroupSize, config.crabSpawnMaxGroupSize);
        }
        if (config.enableGlare && config.enableGlareSpawn) {
            event.add(FriendsAndFoesTags.HAS_GLARE, CustomSpawnGroup.getGlaresCategory(), GLARE.get(), config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMauler && config.enableMaulerSpawn) {
            event.add(FriendsAndFoesTags.HAS_BADLANDS_MAULER, class_1311.field_6294, MAULER.get(), config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            event.add(FriendsAndFoesTags.HAS_DESERT_MAULER, class_1311.field_6294, MAULER.get(), config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            event.add(FriendsAndFoesTags.HAS_SAVANNA_MAULER, class_1311.field_6294, MAULER.get(), config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
        }
        if (config.enableMoobloom && config.enableMoobloomSpawn) {
            event.add(FriendsAndFoesTags.HAS_MOOBLOOMS, class_1311.field_6294, MOOBLOOM.get(), config.moobloomSpawnWeight, config.moobloomSpawnMinGroupSize, config.moobloomSpawnMaxGroupSize);
        }
        if (config.enableRascal && config.enableRascalSpawn) {
            event.add(FriendsAndFoesTags.HAS_RASCAL, CustomSpawnGroup.getRascalsCategory(), RASCAL.get(), 4, 1, 1);
        }
    }

    private FriendsAndFoesEntityTypes() {
    }

    static {
        class_155.field_25135 = false;
        COPPER_GOLEM = ENTITY_TYPES.register("copper_golem", () -> class_1299.class_1300.method_5903(CopperGolemEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 1.375f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("copper_golem")));
        CRAB = ENTITY_TYPES.register("crab", () -> class_1299.class_1300.method_5903(CrabEntity::new, (class_1311)class_1311.field_6294).method_17687(0.875f, 0.5625f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("crab")));
        GLARE = ENTITY_TYPES.register("glare", () -> class_1299.class_1300.method_5903(GlareEntity::new, (class_1311)CustomSpawnGroup.getGlaresCategory()).method_17687(0.875f, 1.1875f).method_27299(8).method_27300(2).method_5905(FriendsAndFoes.makeStringID("glare")));
        ICEOLOGER = ENTITY_TYPES.register("iceologer", () -> class_1299.class_1300.method_5903(IceologerEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.95f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("iceologer")));
        ICE_CHUNK = ENTITY_TYPES.register("ice_chunk", () -> class_1299.class_1300.method_5903(IceologerIceChunkEntity::new, (class_1311)class_1311.field_17715).method_19947().method_17687(2.5f, 1.0f).method_27299(6).method_5905(FriendsAndFoes.makeStringID("ice_chunk")));
        MAULER = ENTITY_TYPES.register("mauler", () -> class_1299.class_1300.method_5903(MaulerEntity::new, (class_1311)class_1311.field_6294).method_17687(0.5625f, 0.5625f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("mauler")));
        MOOBLOOM = ENTITY_TYPES.register("moobloom", () -> class_1299.class_1300.method_5903(MoobloomEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.4f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("moobloom")));
        RASCAL = ENTITY_TYPES.register("rascal", () -> class_1299.class_1300.method_5903(RascalEntity::new, (class_1311)CustomSpawnGroup.getRascalsCategory()).method_17687(0.9f, 1.25f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("rascal")));
        TUFF_GOLEM = ENTITY_TYPES.register("tuff_golem", () -> class_1299.class_1300.method_5903(TuffGolemEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 1.0625f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("tuff_golem")));
        WILDFIRE = ENTITY_TYPES.register("wildfire", () -> class_1299.class_1300.method_5903(WildfireEntity::new, (class_1311)class_1311.field_6302).method_17687(1.12f, 3.0f).method_27299(10).method_19947().method_5905(FriendsAndFoes.makeStringID("wildfire")));
        PLAYER_ILLUSION = ENTITY_TYPES.register("player_illusion", () -> class_1299.class_1300.method_5903(PlayerIllusionEntity::new, (class_1311)class_1311.field_17715).method_17687(0.7f, 1.875f).method_27299(10).method_19947().method_5905(FriendsAndFoes.makeStringID("player_illusion")));
        class_155.field_25135 = previousUseChoiceTypeRegistrations;
    }
}

