/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabBreedTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabDanceTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabGoToHomePositionTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabLayEggTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabLocateBurrowSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabTravelToBurrowSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab.CrabWaveTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSensorTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1856;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4802;
import net.minecraft.class_4818;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_6019;
import net.minecraft.class_6028;

public final class CrabBrain {
    public static final List<class_4140<?>> MEMORY_MODULES;
    public static final List<class_4149<? extends class_4148<? super CrabEntity>>> SENSORS;
    private static final class_6019 WAVE_COOLDOWN_PROVIDER;

    public static class_4095<?> create(Dynamic<?> dynamic) {
        class_4095.class_5303 profile = class_4095.method_28311(MEMORY_MODULES, SENSORS);
        class_4095 brain = profile.method_28335(dynamic);
        CrabBrain.addCoreActivities((class_4095<CrabEntity>)brain);
        CrabBrain.addIdleActivities((class_4095<CrabEntity>)brain);
        CrabBrain.addLayEggActivities((class_4095<CrabEntity>)brain);
        CrabBrain.addDanceActivities((class_4095<CrabEntity>)brain);
        CrabBrain.addWaveActivities((class_4095<CrabEntity>)brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(class_4095<CrabEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_6028(2.0f), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get())));
    }

    private static void addLayEggActivities(class_4095<CrabEntity> brain) {
        brain.method_24529(FriendsAndFoesActivities.CRAB_LAY_EGG.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabGoToHomePositionTask())), (Object)Pair.of((Object)1, (Object)((Object)new CrabLocateBurrowSpotTask())), (Object)Pair.of((Object)2, (Object)((Object)new CrabTravelToBurrowSpotTask())), (Object)Pair.of((Object)3, (Object)((Object)new CrabLayEggTask()))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)class_4141.field_18456)));
    }

    private static void addDanceActivities(class_4095<CrabEntity> brain) {
        brain.method_24529(FriendsAndFoesActivities.CRAB_DANCE.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabDanceTask()))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_18448, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_28325, (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (Object)class_4141.field_18457)));
    }

    private static void addWaveActivities(class_4095<CrabEntity> brain) {
        brain.method_24529(FriendsAndFoesActivities.CRAB_WAVE.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CrabWaveTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_18444, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_18448, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_28325, (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)class_4141.field_18457), (Object[])new Pair[]{Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (Object)class_4141.field_18457)}));
    }

    private static void addIdleActivities(class_4095<CrabEntity> brain) {
        brain.method_24529(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_5754(crab -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)((Object)new CrabBreedTask(FriendsAndFoesEntityTypes.CRAB.get(), 1.0f))), (Object)Pair.of((Object)2, (Object)class_5355.method_46896((class_6019)class_6019.method_35017((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), (Object)class_4141.field_18456), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)class_4141.field_18457), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (Object)class_4141.field_18457)));
    }

    public static void updateActivities(CrabEntity crab) {
        crab.method_18868().method_24531((List)ImmutableList.of((Object)FriendsAndFoesActivities.CRAB_LAY_EGG.get(), (Object)FriendsAndFoesActivities.CRAB_DANCE.get(), (Object)FriendsAndFoesActivities.CRAB_WAVE.get(), (Object)class_4168.field_18595));
    }

    public static void updateMemories(CrabEntity crab) {
        if (crab.hasEgg()) {
            crab.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)true);
        } else {
            crab.method_18868().method_18875(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get());
        }
        if (crab.isDancing() && !crab.method_6101()) {
            crab.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), (Object)true);
        } else {
            crab.method_18868().method_18875(FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get());
        }
    }

    public static void setWaveCooldown(CrabEntity crab) {
        crab.method_18868().method_18878(FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), (Object)WAVE_COOLDOWN_PROVIDER.method_35008(crab.method_6051()));
    }

    public static class_1856 getTemptItems() {
        return class_1856.method_8106(FriendsAndFoesTags.CRAB_TEMPT_ITEMS);
    }

    static {
        SENSORS = List.of(class_4149.field_18466, class_4149.field_18467, class_4149.field_25362, FriendsAndFoesSensorTypes.CRAB_TEMPTATIONS.get());
        MEMORY_MODULES = List.of(class_4140.field_28325, class_4140.field_28326, class_4140.field_28327, class_4140.field_18442, class_4140.field_18449, class_4140.field_18446, class_4140.field_18445, class_4140.field_18448, class_4140.field_39408, class_4140.field_19293, class_4140.field_18444, class_4140.field_22332, FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), FriendsAndFoesMemoryModuleTypes.CRAB_IS_DANCING.get(), FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get());
        WAVE_COOLDOWN_PROVIDER = class_4802.method_24505((int)20, (int)40);
    }
}

