/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.api;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public final class StoneStrataHandler {
    private final List<String> stoneStrata;
    private final Pattern tagMatcher;
    private final TagMap<class_1792> stoneStrataTagMap;
    private final Map<UnifyTag<?>, Boolean> stoneStrataTagCache;
    private final Map<class_2960, String> stoneStrataCache;

    private StoneStrataHandler(List<String> stoneStrata, Pattern tagMatcher, TagMap<class_1792> stoneStrataTagMap) {
        this.stoneStrata = StoneStrataHandler.createSortedStoneStrata(stoneStrata);
        this.tagMatcher = tagMatcher;
        this.stoneStrataTagMap = stoneStrataTagMap;
        this.stoneStrataTagCache = new HashMap();
        this.stoneStrataCache = new HashMap<class_2960, String>();
    }

    private static List<String> createSortedStoneStrata(List<String> stoneStrata) {
        return stoneStrata.stream().sorted(Comparator.comparingInt(String::length).reversed()).toList();
    }

    public static StoneStrataHandler create(List<String> stoneStrataIds, Set<UnifyTag<class_1792>> stoneStrataTags, TagMap<class_1792> tagMap) {
        TagMap<class_1792> stoneStrataTagMap = tagMap.filtered(stoneStrataTags::contains, item -> true);
        Pattern tagMatcher = Pattern.compile(switch (AlmostUnifiedPlatform.INSTANCE.getPlatform()) {
            default -> throw new IncompatibleClassChangeError();
            case AlmostUnifiedPlatform.Platform.FORGE -> "forge:ores/.+";
            case AlmostUnifiedPlatform.Platform.FABRIC -> "(c:ores/.+|(minecraft|c):.+_ores)";
        });
        return new StoneStrataHandler(stoneStrataIds, tagMatcher, stoneStrataTagMap);
    }

    public String getStoneStrata(class_2960 item) {
        return this.stoneStrataCache.computeIfAbsent(item, this::computeStoneStrata);
    }

    private String computeStoneStrata(class_2960 item) {
        String strata = this.stoneStrataTagMap.getTagsByEntry(item).stream().findFirst().map(UnifyTag::location).map(class_2960::toString).map(s -> {
            int i = s.lastIndexOf(47);
            return i == -1 ? null : s.substring(i + 1);
        }).orElse(null);
        if (strata != null) {
            if (strata.equals("stone")) {
                return "";
            }
            return strata;
        }
        for (String stone : this.stoneStrata) {
            if (!item.method_12832().contains(stone + "_")) continue;
            if (stone.equals("stone")) {
                return "";
            }
            return stone;
        }
        return "";
    }

    public boolean isStoneStrataTag(UnifyTag<class_1792> tag) {
        return this.stoneStrataTagCache.computeIfAbsent(tag, t -> this.tagMatcher.matcher(t.location().toString()).matches());
    }
}

