/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.mixin.nbt;

import com.recipeessentials.nbt.IEqualTag;
import com.recipeessentials.nbt.IParentAwareTag;
import com.recipeessentials.nbt.IParentTag;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CompoundTag.class})
public abstract class CompoundNBTMixin
implements IParentTag,
IParentAwareTag,
IEqualTag,
Tag {
    @Shadow
    @Final
    @Mutable
    private Map<String, Tag> tags;
    @Unique
    private int hashCode = -1;
    @Unique
    private IEqualTag equalTo = null;
    @Unique
    private IParentTag parentTag = null;

    @Overwrite
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.tags.hashCode();
        }
        return this.hashCode;
    }

    @Redirect(method={"put", "putByte", "putShort", "putInt", "putLong", "putUUID", "putFloat", "putDouble", "putString", "putByteArray", "putIntArray", "putLongArray", "putBoolean"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object onPut(Map map, Object key, Object value) {
        this.markDirty();
        return map.put(key, value);
    }

    @Redirect(method={"putByteArray(Ljava/lang/String;Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object onPutByteArray(Map map, Object key, Object value) {
        this.markDirty();
        return map.put(key, value);
    }

    @Redirect(method={"putIntArray(Ljava/lang/String;Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object onPutIntArray(Map map, Object key, Object value) {
        this.markDirty();
        return map.put(key, value);
    }

    @Redirect(method={"putLongArray(Ljava/lang/String;Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object onPutLongArray(Map map, Object key, Object value) {
        this.markDirty();
        return map.put(key, value);
    }

    @Inject(method={"get"}, at={@At(value="RETURN")})
    public void get(String p_128424_, CallbackInfoReturnable<Tag> cir) {
        Tag v = (Tag)cir.getReturnValue();
        if (v instanceof IParentAwareTag) {
            ((IParentAwareTag)v).setParent(this);
        }
    }

    @Inject(method={"getCompound"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)})
    public void getCompound(String p_128424_, CallbackInfoReturnable<Tag> cir) {
        Tag v = (Tag)cir.getReturnValue();
        if (v instanceof IParentAwareTag) {
            ((IParentAwareTag)v).setParent(this);
        }
    }

    @Inject(method={"getList"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)})
    public void getList(String p_128438_, int p_128439_, CallbackInfoReturnable<ListTag> cir) {
        Tag v = (Tag)cir.getReturnValue();
        if (v instanceof IParentAwareTag) {
            ((IParentAwareTag)v).setParent(this);
        }
    }

    @Inject(method={"put"}, at={@At(value="RETURN")})
    public void put(String p_128366_, Tag tag, CallbackInfoReturnable<Tag> cir) {
        if (tag instanceof IParentAwareTag) {
            ((IParentAwareTag)tag).setParent(this);
        }
        this.markDirty();
    }

    @Inject(method={"remove"}, at={@At(value="RETURN")})
    public void remove(String p_128474_, CallbackInfo ci) {
        this.markDirty();
    }

    @Inject(method={"merge"}, at={@At(value="RETURN")})
    private void onMerge(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        if (tag instanceof IParentAwareTag) {
            ((IParentAwareTag)tag).setParent(this);
        }
        this.markDirty();
    }

    @Inject(method={"equals"}, at={@At(value="INVOKE", target="Ljava/util/Objects;equals(Ljava/lang/Object;Ljava/lang/Object;)Z")}, cancellable=true)
    public void befOreComparetest(Object compound2, CallbackInfoReturnable<Boolean> cir) {
        if (this == compound2) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (compound2 instanceof IEqualTag && this.hashCode() == compound2.hashCode()) {
            if (this.equalTo == compound2 && ((IEqualTag)compound2).getLastEqual() == this) {
                cir.setReturnValue((Object)true);
                return;
            }
        } else {
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"equals"}, at={@At(value="RETURN", target="Ljava/util/Objects;equals(Ljava/lang/Object;Ljava/lang/Object;)Z")})
    public void afterComparetest(Object compound2, CallbackInfoReturnable<Boolean> cir) {
        if (this == compound2) {
            return;
        }
        if (cir.getReturnValueZ()) {
            this.equalTo = (IEqualTag)compound2;
            ((IEqualTag)compound2).setLastEqual(this);
        }
    }

    @Override
    public void setLastEqual(IEqualTag compoundNBT) {
        this.equalTo = compoundNBT;
    }

    @Override
    public void markDirty() {
        if (this.hashCode == -1) {
            return;
        }
        this.hashCode = -1;
        this.equalTo = null;
        if (this.parentTag != null && this.parentTag != this) {
            this.parentTag.markDirty();
            this.parentTag = null;
        }
    }

    @Override
    public IEqualTag getLastEqual() {
        return this.equalTo;
    }

    @Inject(method={"getCompound"}, at={@At(value="RETURN")})
    private void onGetCompound(String p_128470_, CallbackInfoReturnable<CompoundTag> cir) {
        ((IParentAwareTag)cir.getReturnValue()).setParent(this);
    }

    @Override
    public void setParent(IParentTag tag) {
        this.parentTag = tag;
    }

    @Override
    public IParentTag parent() {
        return this.parentTag;
    }
}

