/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.neoforge.cobalt.registration;

import immersive_armors.cobalt.registration.Registration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RegistrationImpl
extends Registration.Impl {
    private final Map<String, RegistryRepo> repos = new HashMap<String, RegistryRepo>();
    private final IEventBus modBus;

    public RegistrationImpl(IEventBus modBus) {
        this.modBus = modBus;
    }

    private RegistryRepo getRepo(String namespace) {
        return this.repos.computeIfAbsent(namespace, x$0 -> new RegistryRepo((String)x$0));
    }

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, ResourceLocation id, Supplier<T> obj) {
        DeferredRegister reg = this.getRepo(id.getNamespace()).get(registry);
        return reg.register(id.getPath(), obj);
    }

    class RegistryRepo {
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();
        private final String namespace;

        public RegistryRepo(String namespace) {
            this.namespace = namespace;
        }

        public <T> DeferredRegister get(Registry<? super T> registry) {
            ResourceLocation id = registry.key().registry();
            if (!this.registries.containsKey(id)) {
                DeferredRegister def = DeferredRegister.create(registry, (String)this.namespace);
                def.register(RegistrationImpl.this.modBus);
                this.registries.put(id, def);
            }
            return this.registries.get(id);
        }
    }
}

