/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import com.google.common.base.Suppliers;
import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ExtendedArmorItem
extends ArmorItem {
    private Supplier<ItemAttributeModifiers> attributeModifiers;
    private final ExtendedArmorMaterial material;

    public ExtendedArmorItem(Item.Properties settings, ArmorItem.Type slot, ExtendedArmorMaterial material) {
        super(material.getRegistryReference(), slot, settings.durability(slot.getDurability(material.getDurabilityMultiplier())));
        this.material = material;
        this.refreshAttributes();
    }

    public int getDefense() {
        return this.material.getProtection(this.type);
    }

    public float getToughness() {
        return this.material.getToughness();
    }

    public void refreshAttributes() {
        this.attributeModifiers = Suppliers.memoize(() -> {
            float waterMovement;
            float movementSpeed;
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot());
            ResourceLocation identifier = ResourceLocation.withDefaultNamespace((String)("armor." + this.type.getName()));
            builder.add(Attributes.ARMOR, new AttributeModifier(identifier, (double)this.material.getProtection(this.type), AttributeModifier.Operation.ADD_VALUE), slot);
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(identifier, (double)this.material.getToughness(), AttributeModifier.Operation.ADD_VALUE), slot);
            float knockbackResistance = this.material.getKnockbackResistance();
            if (knockbackResistance > 0.0f) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(identifier, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), slot);
            }
            if ((movementSpeed = -this.material.getWeight()) != 0.0f) {
                builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(identifier, (double)movementSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), slot);
            }
            if ((waterMovement = this.material.getWaterMovement()) != 0.0f) {
                builder.add(Attributes.WATER_MOVEMENT_EFFICIENCY, new AttributeModifier(identifier, (double)waterMovement, AttributeModifier.Operation.ADD_VALUE), slot);
            }
            return builder.build();
        });
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.attributeModifiers.get();
    }

    public ExtendedArmorMaterial getExtendedMaterial() {
        return this.material;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
            e.appendTooltip(stack, context, tooltip, type);
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        LivingEntity livingEntity;
        ItemStack equippedStack;
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof LivingEntity && (equippedStack = (livingEntity = (LivingEntity)entity).getItemBySlot(this.getEquipmentSlot())) == stack) {
            for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
                e.equippedTick(stack, world, livingEntity, slot);
            }
        }
    }

    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
            amount = e.applyArmorToDamage(entity, source, amount, armor);
        }
        return amount;
    }

    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
            amount = e.applyArmorToAttack(target, source, amount, armor);
        }
        return amount;
    }
}

