/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.DyeableExtendedArmorItem;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;

public abstract class LayerPiece
extends Piece {
    protected final TextureAtlas armorTrimsAtlas = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);

    protected abstract HumanoidModel<LivingEntity> getModel();

    protected static HumanoidModel<LivingEntity> buildDilatedModel(float dilation) {
        return LayerPiece.buildDilatedModel(dilation, dilation);
    }

    protected static HumanoidModel<LivingEntity> buildDilatedModel(float dilation, float headDilation) {
        return new HumanoidModel(LayerDefinition.create((MeshDefinition)LayerPiece.getHeadAdjustedModelData(new CubeDeformation(dilation), new CubeDeformation(headDilation), 0.0f), (int)64, (int)32).bakeRoot());
    }

    public static MeshDefinition getHeadAdjustedModelData(CubeDeformation dilation, CubeDeformation headDilation, float pivotOffsetY) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, headDilation), PartPose.offset((float)0.0f, (float)(0.0f + pivotOffsetY), (float)0.0f));
        modelPartData.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, headDilation.extend(0.5f)), PartPose.offset((float)0.0f, (float)(0.0f + pivotOffsetY), (float)0.0f));
        modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, dilation), PartPose.offset((float)0.0f, (float)(0.0f + pivotOffsetY), (float)0.0f));
        modelPartData.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.offset((float)-5.0f, (float)(2.0f + pivotOffsetY), (float)0.0f));
        modelPartData.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.offset((float)5.0f, (float)(2.0f + pivotOffsetY), (float)0.0f));
        modelPartData.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.offset((float)-1.9f, (float)(12.0f + pivotOffsetY), (float)0.0f));
        modelPartData.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.offset((float)1.9f, (float)(12.0f + pivotOffsetY), (float)0.0f));
        return modelData;
    }

    protected void renderTrim(Holder<ArmorMaterial> material, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmorTrim trim, HumanoidModel<LivingEntity> model, boolean leggings) {
        TextureAtlasSprite sprite = this.armorTrimsAtlas.getSprite(leggings ? trim.innerTexture(material) : trim.outerTexture(material));
        VertexConsumer vertexConsumer = sprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
        model.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
    }

    @Override
    public <T extends LivingEntity, A extends HumanoidModel<T>> void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, ItemStack itemStack, float tickDelta, EquipmentSlot armorSlot, A armorModel) {
        Item item = itemStack.getItem();
        if (item instanceof ExtendedArmorItem) {
            ExtendedArmorItem armorItem = (ExtendedArmorItem)item;
            armorModel.copyPropertiesTo(this.getModel());
            this.setVisible(this.getModel(), armorSlot);
            if (armorItem instanceof DyeableExtendedArmorItem) {
                DyeableExtendedArmorItem dyeableArmorItem = (DyeableExtendedArmorItem)armorItem;
                int c = dyeableArmorItem.getColor(itemStack);
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), c + -16777216, false);
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), -1, true);
            } else {
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), -1, false);
            }
            ArmorTrim trim = (ArmorTrim)itemStack.get(DataComponents.TRIM);
            if (trim != null) {
                this.renderTrim((Holder<ArmorMaterial>)armorItem.getMaterial(), matrices, vertexConsumers, light, trim, this.getModel(), armorSlot == EquipmentSlot.LEGS);
            }
        }
    }
}

