/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.vertex.PoseStack;
import immersive_armors.client.render.entity.model.DecoModel;
import immersive_armors.client.render.entity.piece.Piece;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class ItemPiece
extends Piece {
    private final String attachTo;
    private final float x;
    private final float y;
    private final float z;
    private final float size;
    private final ItemStack stack;
    private final Quaternionf rotation;

    public ItemPiece(String to, float x, float y, float z, float size, ItemStack stack) {
        this(to, x, y, z, size, stack, null);
    }

    public ItemPiece(String to, float x, float y, float z, float size, ItemStack stack, @Nullable Quaternionf rotation) {
        this.attachTo = to;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
        this.stack = stack;
        this.rotation = rotation;
    }

    @Override
    public <T extends LivingEntity, A extends HumanoidModel<T>> void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, ItemStack itemStack, float tickDelta, EquipmentSlot armorSlot, A armorModel) {
        matrices.pushPose();
        DecoModel.getModelPart(armorModel, this.attachTo).translateAndRotate(matrices);
        matrices.translate(this.x, this.y, this.z);
        matrices.scale(this.size, -this.size, -this.size);
        if (this.rotation != null) {
            matrices.mulPose(this.rotation);
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(entity, this.stack, ItemDisplayContext.GROUND, false, matrices, vertexConsumers, entity.level(), light, OverlayTexture.NO_OVERLAY, 0);
        matrices.popPose();
    }
}

