/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client;

import immersive_armors.Main;
import immersive_armors.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class OverlayRenderer {
    private static final ItemStack clock = new ItemStack((ItemLike)Items.CLOCK);
    private static final ItemStack compass = new ItemStack((ItemLike)Items.COMPASS);

    public static void renderOverlay(GuiGraphics context) {
        Minecraft client = Minecraft.getInstance();
        if (!client.options.hideGui && client.gameMode != null && client.player != null) {
            for (ItemStack item : client.player.getArmorSlots()) {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
                if (!id.equals((Object)Main.locate("steampunk_chestplate"))) continue;
                OverlayRenderer.renderSteampunkHud(context);
            }
        }
    }

    private static void renderSteampunkHud(GuiGraphics context) {
        ItemStack itemStack;
        Player player;
        Player playerEntity;
        Minecraft client = Minecraft.getInstance();
        HumanoidArm arm = null;
        Entity entity = client.getCameraEntity();
        Player player2 = playerEntity = entity instanceof Player ? (player = (Player)entity) : null;
        if (playerEntity != null && !(itemStack = playerEntity.getOffhandItem()).isEmpty()) {
            arm = playerEntity.getMainArm().getOpposite();
        }
        int scaledWidth = client.getWindow().getGuiScaledWidth();
        int scaledHeight = client.getWindow().getGuiScaledHeight();
        context.renderItem(clock, scaledWidth / 2 + (arm == HumanoidArm.LEFT ? Config.getInstance().hudClockXOffhand : Config.getInstance().hudClockX), scaledHeight + Config.getInstance().hudClockY);
        context.renderItem(compass, scaledWidth / 2 + (arm == HumanoidArm.RIGHT ? Config.getInstance().hudCompassXOffhand : Config.getInstance().hudCompassX), scaledHeight + Config.getInstance().hudCompassY);
    }
}

