/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import immersive_armors.armor_effects.ArmorEffect;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WitherArmorEffect
extends ArmorEffect {
    private final float immunity;
    private final int wither;

    public WitherArmorEffect(float immunity, int wither) {
        this.immunity = immunity;
        this.wither = wither;
    }

    @Override
    public void appendTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"armorEffect.wither", (Object[])new Object[]{this.wither}).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        LivingEntity attacker;
        Entity entity2;
        int setCount = this.getSetCount(armor, entity);
        if (this.isPrimaryArmor(armor, entity) && (entity2 = source.getEntity()) instanceof LivingEntity && !(attacker = (LivingEntity)entity2).fireImmune()) {
            attacker.addEffect(new MobEffectInstance(MobEffects.WITHER, this.wither * setCount, 1));
        }
        if (source.is(DamageTypes.WITHER)) {
            return amount * Math.min(1.0f, 1.0f - this.immunity * (float)setCount);
        }
        return amount;
    }
}

