/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import com.mojang.serialization.Codec;
import immersive_armors.CustomDataComponentTypes;
import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.cobalt.network.NetworkHandler;
import immersive_armors.network.c2s.ArmorCommandMessage;
import immersive_armors.util.EnumCodec;
import immersive_armors.util.EnumPacketCodec;
import immersive_armors.util.FlowingText;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SteamTechArmorEffect
extends ArmorEffect {
    @Override
    public void appendTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        MutableComponent text = Component.translatable((String)("armorEffect.steamTech." + this.getEquipmentSlot(stack).name().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.GRAY);
        tooltip.addAll(FlowingText.wrap((Component)text, 140));
    }

    @Override
    public void equippedTick(ItemStack armor, Level world, LivingEntity entity, int slot) {
        super.equippedTick(armor, world, entity, slot);
        if (this.getEquipmentSlot(armor) == EquipmentSlot.FEET) {
            Vec3 velocity;
            entity.fallDistance = Math.min(1.0f, entity.fallDistance);
            if (entity.getRandom().nextInt(10) == 0) {
                double x = Math.cos((double)(entity.yBodyRot / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                double z = Math.sin((double)(entity.yBodyRot / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, entity.getX() + x, entity.getY() + (double)1.2f, entity.getZ() + z, x * (double)0.2f, (double)-0.025f, z * (double)0.2f);
            }
            if ((velocity = entity.getDeltaMovement()).y() < -0.75 && !entity.isFallFlying()) {
                entity.setDeltaMovement(velocity.x, -0.75, velocity.z);
                this.createSteamParticle(entity);
                if (entity.tickCount % 5 == 0) {
                    entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.REDSTONE_TORCH_BURNOUT, entity.getSoundSource(), 0.1f, 1.0f);
                }
            }
        }
        if (!world.isClientSide() && entity.isShiftKeyDown() && this.getEquipmentSlot(armor) == EquipmentSlot.HEAD && entity.tickCount % 20 == 0) {
            boolean[] sound = new boolean[]{false};
            world.getEntities((Entity)entity, new AABB(entity.position(), entity.position()).inflate(16.0)).forEach(e -> {
                if (e instanceof Monster) {
                    Monster hostileEntity = (Monster)e;
                    hostileEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 5));
                    if (!sound[0]) {
                        sound[0] = true;
                        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.STONE_BUTTON_CLICK_ON, entity.getSoundSource(), 0.25f, 3.0f);
                    }
                }
            });
        }
        if (world.isClientSide && this.getEquipmentSlot(armor) == EquipmentSlot.LEGS) {
            if (entity.onGround()) {
                armor.set(CustomDataComponentTypes.THRUSTER_STATE, (Object)ThrusterState.CHARGED);
            } else if (armor.get(CustomDataComponentTypes.THRUSTER_STATE) == ThrusterState.CHARGED) {
                if (!this.isJumping()) {
                    armor.set(CustomDataComponentTypes.THRUSTER_STATE, (Object)ThrusterState.READY);
                }
            } else if (armor.get(CustomDataComponentTypes.THRUSTER_STATE) == ThrusterState.READY && this.isJumping()) {
                this.thrust(entity);
                armor.set(CustomDataComponentTypes.THRUSTER_STATE, (Object)ThrusterState.OFFLINE);
                NetworkHandler.sendToServer(new ArmorCommandMessage(slot, "thrust"));
            }
        }
    }

    private void createSteamParticle(LivingEntity entity) {
        entity.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, entity.getRandomX(0.5), entity.getY() - 0.25, entity.getRandomZ(0.5), ((double)entity.getRandom().nextFloat() - 0.5) * 0.1, -0.75 + ((double)entity.getRandom().nextFloat() - 0.5) * 0.1, ((double)entity.getRandom().nextFloat() - 0.5) * 0.1);
    }

    @Override
    public void receiveCommand(ItemStack armor, Level world, LivingEntity entity, int slot, String command) {
        if (command.equals("thrust")) {
            this.thrust(entity);
        }
    }

    private boolean isJumping() {
        Minecraft client = Minecraft.getInstance();
        return client != null && client.player != null && client.player.input.jumping;
    }

    private void thrust(LivingEntity entity) {
        Vec3 velocity = entity.getDeltaMovement();
        entity.setDeltaMovement(velocity.x, 0.6, velocity.z);
        for (int i = 0; i < 5; ++i) {
            this.createSteamParticle(entity);
        }
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.REDSTONE_TORCH_BURNOUT, entity.getSoundSource(), 0.25f, 0.75f);
    }

    private EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return ((ArmorItem)stack.getItem()).getEquipmentSlot();
    }

    public static enum ThrusterState {
        OFFLINE,
        CHARGED,
        READY;

        public static final Codec<ThrusterState> CODEC;
        public static final StreamCodec<ByteBuf, ThrusterState> PACKET_CODEC;

        static {
            CODEC = new EnumCodec<ThrusterState>(ThrusterState.class);
            PACKET_CODEC = new EnumPacketCodec<ThrusterState>(ThrusterState.class);
        }
    }
}

