/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import immersive_armors.armor_effects.ArmorEffect;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BerserkArmorEffect
extends ArmorEffect {
    private final float berserk;

    public BerserkArmorEffect(float berserk) {
        this.berserk = berserk;
    }

    @Override
    public void appendTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"armorEffect.berserk", (Object[])new Object[]{(int)(this.berserk * 100.0f)}).withStyle(ChatFormatting.RED));
    }

    @Override
    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        LivingEntity attacker;
        Entity entity = source.getEntity();
        if (entity instanceof LivingEntity && this.isPrimaryArmor(armor, attacker = (LivingEntity)entity)) {
            float healthFactor = attacker.getHealth() / attacker.getMaxHealth();
            amount *= 1.0f + (float)this.getSetCount(armor, attacker) * this.berserk * (1.0f - healthFactor);
        }
        return amount;
    }
}

