/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingOtherPlayerPacket;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.networking.clientbound.ClientboundSyncCarryDataPacket;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.networking.serverbound.ServerboundCarryKeyPressedPacket;
import tschipp.carryon.platform.Services;

public class CarryOnCommon {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder();

    public static HolderLookup.Provider createLookup() {
        RegistryAccess.Frozen registryaccess$frozen = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        HolderLookup.Provider holderlookup$provider = BUILDER.build((RegistryAccess)registryaccess$frozen);
        return holderlookup$provider;
    }

    public static void registerServerPackets(Object ... args) {
        Services.PLATFORM.registerServerboundPacket(ServerboundCarryKeyPressedPacket.TYPE, ServerboundCarryKeyPressedPacket.class, ServerboundCarryKeyPressedPacket.CODEC, ServerboundCarryKeyPressedPacket::handle, args);
    }

    public static void registerClientPackets(Object ... args) {
        Services.PLATFORM.registerClientboundPacket(ClientboundStartRidingPacket.TYPE, ClientboundStartRidingPacket.class, ClientboundStartRidingPacket.CODEC, ClientboundStartRidingPacket::handle, args);
        Services.PLATFORM.registerClientboundPacket(ClientboundSyncScriptsPacket.TYPE, ClientboundSyncScriptsPacket.class, ClientboundSyncScriptsPacket.CODEC, ClientboundSyncScriptsPacket::handle, args);
        Services.PLATFORM.registerClientboundPacket(ClientboundStartRidingOtherPlayerPacket.TYPE, ClientboundStartRidingOtherPlayerPacket.class, ClientboundStartRidingOtherPlayerPacket.CODEC, ClientboundStartRidingOtherPlayerPacket::handle, args);
        Services.PLATFORM.registerClientboundPacket(ClientboundSyncCarryDataPacket.TYPE, ClientboundSyncCarryDataPacket.class, ClientboundSyncCarryDataPacket.CODEC, ClientboundSyncCarryDataPacket::handle, args);
    }

    public static void registerConfig() {
        ConfigLoader.registerConfig(Constants.COMMON_CONFIG);
        ConfigLoader.registerConfig(Constants.CLIENT_CONFIG);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandCarryOn.register(dispatcher);
    }

    public static void onCarryTick(ServerPlayer player) {
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (carry.isCarrying()) {
            String cmd;
            if (player.tickCount == 1) {
                CarryOnDataManager.setCarryData((Player)player, carry);
            }
            if (carry.getActiveScript().isPresent() && !(cmd = carry.getActiveScript().get().scriptEffects().commandLoop()).isEmpty()) {
                player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().getName() + " run " + cmd);
            }
            if (!Constants.COMMON_CONFIG.settings.slownessInCreative && player.isCreative()) {
                return;
            }
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 1, CarryOnCommon.potionLevel(carry, player.level()), false, false));
            Inventory inv = player.getInventory();
            inv.selected = carry.getSelected();
        }
    }

    public static boolean onTryBreakBlock(Player player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static boolean onAttackedByPlayer(Player player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static void onPlayerAttacked(Player player) {
        CarryOnData carry;
        if (Constants.COMMON_CONFIG.settings.dropCarriedWhenHit && !player.level().isClientSide && (carry = CarryOnDataManager.getCarryData(player)).isCarrying()) {
            PlacementHandler.placeCarried((ServerPlayer)player);
        }
    }

    public static void onRiderDisconnected(Player rider) {
        ServerPlayer vehicle;
        CarryOnData data;
        Entity entity = rider.getVehicle();
        if (entity instanceof ServerPlayer && (data = CarryOnDataManager.getCarryData((Player)(vehicle = (ServerPlayer)entity))).isCarrying(CarryOnData.CarryType.PLAYER)) {
            PlacementHandler.placeCarried(vehicle);
        }
    }

    public static int potionLevel(CarryOnData carry, Level level) {
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return 1;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = carry.getEntity(level);
            int i = (int)(entity.getBbHeight() * entity.getBbWidth());
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyEntities) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.entitySlownessMultiplier);
        }
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            String nbt = carry.getNbt().toString();
            int i = nbt.length() / 500;
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyTiles) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.blockSlownessMultiplier);
        }
        return 0;
    }
}

