/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.common.network.ClientReceivers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;

public record SyncPartyCreeperPacket(int entityID, boolean on) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, SyncPartyCreeperPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("sync_party_creeper"), SyncPartyCreeperPacket::new);

    public SyncPartyCreeperPacket(FriendlyByteBuf buf) {
        this(buf.readVarInt(), buf.readBoolean());
    }

    public SyncPartyCreeperPacket(LivingEntity entity) {
        this(entity.getId(), entity instanceof IPartyCreeper && (pc = (IPartyCreeper)entity).supplementaries$isFestive());
        IPartyCreeper pc;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.entityID);
        buf.writeBoolean(this.on);
    }

    public void handle(Message.Context context) {
        if (context.getDirection() == Message.NetworkDir.SERVER_BOUND) {
            Entity e = context.getPlayer().level().getEntity(this.entityID);
            if (e instanceof Creeper) {
                IPartyCreeper pc;
                Creeper c = (Creeper)e;
                if (e instanceof IPartyCreeper && (pc = (IPartyCreeper)e).supplementaries$isFestive()) {
                    NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new SyncPartyCreeperPacket((LivingEntity)c));
                }
            }
        } else {
            ClientReceivers.handleSyncPartyCreeper(this);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

