/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BuiltinAnimation;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataDefinedCatchableMob;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DataCapturedMobInstance<T extends Entity>
extends CapturedMobInstance<T> {
    private final DataDefinedCatchableMob properties;
    @Nullable
    private final BuiltinAnimation<T> builtinAnimationInstance;

    protected DataCapturedMobInstance(T entity, DataDefinedCatchableMob type) {
        super(entity);
        this.properties = type;
        this.builtinAnimationInstance = BuiltinAnimation.get(entity, this.properties.builtinAnimation);
    }

    @Override
    public void containerTick(Level world, BlockPos pos, float entityScale, CompoundTag entityData) {
        Entity entity;
        ++this.entity.tickCount;
        if (this.properties.tickMode.isValid(world) && (entity = this.entity) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.aiStep();
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            this.properties.loot.ifPresent(lootParam -> lootParam.tryDropping(serverLevel, pos, this.entity));
        }
        if (this.builtinAnimationInstance != null) {
            this.builtinAnimationInstance.tick(this.entity, world, pos);
        }
    }

    @Override
    public void onContainerWaterlogged(boolean waterlogged, float containerWidth, float containerHeight) {
        Holder f = this.properties.renderFluid.orElse(null);
        if (!waterlogged && f != null && MLBuiltinSoftFluids.WATER.is(f)) {
            super.onContainerWaterlogged(true, containerWidth, containerHeight);
        } else {
            super.onContainerWaterlogged(waterlogged, containerWidth, containerHeight);
        }
    }
}

