/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.supplementaries.common.worldgen.LocatedStructure;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventurerMapsHandler {
    public static ItemStack createMapOrQuill(ServerLevel serverLevel, BlockPos pos, @Nullable HolderSet<Structure> targets, int radius, boolean skipKnown, int zoom, @Nullable ResourceLocation mapMarker, @Nullable String name, int color) {
        if (!serverLevel.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return ItemStack.EMPTY;
        }
        if (targets == null) {
            targets = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(ModTags.ADVENTURE_MAP_DESTINATIONS).orElse(null);
        }
        if (targets == null || targets.size() < 1) {
            return ItemStack.EMPTY;
        }
        if (CompatHandler.QUARK && CommonConfigs.Tweaks.QUARK_QUILL.get().booleanValue()) {
            ItemStack item = QuarkCompat.makeAdventurerQuill(serverLevel, (HolderSet<Structure>)targets, radius, skipKnown, zoom, mapMarker, name, color);
            if (name != null) {
                item.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)name));
            }
            return item;
        }
        int maxSearches = CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAPS_MAX_SEARCHES.get();
        LocatedStructure found = StructureLocator.findNearestStructure(serverLevel, (HolderSet<Structure>)targets, pos, radius, skipKnown, maxSearches, false);
        if (found != null) {
            BlockPos toPos = found.position();
            return AdventurerMapsHandler.createStructureMap(serverLevel, toPos, found.structure(), zoom, mapMarker, name, color);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public static ItemStack createStructureMap(ServerLevel level, BlockPos pos, Holder<Structure> structure, int zoom, @Nullable ResourceLocation decoration, @Nullable String name, int color) {
        ItemStack stack = MapItem.create((Level)level, (int)pos.getX(), (int)pos.getZ(), (byte)((byte)zoom), (boolean)true, (boolean)true);
        MapItem.renderBiomePreviewMap((ServerLevel)level, (ItemStack)stack);
        if (decoration == null) {
            Holder type = MapDataRegistry.getDecorationFoStructure((Level)level, structure);
            decoration = ((ResourceKey)type.unwrapKey().get()).location();
            if (color == 0) {
                color = ((MLMapDecorationType)type.value()).getDefaultMapColor();
            }
        }
        MapHelper.addTargetDecorationToItem((Level)level, (ItemStack)stack, (BlockPos)pos, (ResourceLocation)decoration, (int)color);
        if (name != null) {
            stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)name));
        }
        return stack;
    }

    public static ItemStack createCustomMapForTrade(Level level, BlockPos pos, HolderSet<Structure> destinations, @Nullable String mapName, int mapColor, @Nullable ResourceLocation mapMarker) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return AdventurerMapsHandler.createMapOrQuill(serverLevel, pos, destinations, CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAX_SEARCH_RADIUS.get(), true, 2, mapMarker, mapName, mapColor);
        }
        return ItemStack.EMPTY;
    }
}

