/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import net.mehvahdjukaar.moonlight.api.block.OpenableContainerBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LunchBoxBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.VariableSizeContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.LunchBoxItem;
import net.mehvahdjukaar.supplementaries.common.items.components.LunchBaskedContent;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LunchBoxBlockTile
extends OpenableContainerBlockTile {
    @Nullable
    private DyedItemColor dyeColor = null;

    public LunchBoxBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.LUNCH_BASKET_TILE.get(), pos, state, 27);
    }

    public static int getUnlockedSlots() {
        return CommonConfigs.Tools.LUNCH_BOX_SLOTS.get();
    }

    public int getContainerSize() {
        return LunchBoxBlockTile.getUnlockedSlots();
    }

    protected void playOpenSound(BlockState state) {
        double d0 = (double)this.worldPosition.getX() + 0.5;
        double d1 = (double)this.worldPosition.getY() + 1.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5;
        this.level.playSound(null, d0, d1, d2, ModSounds.LUNCH_BASKET_OPEN.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.95f);
    }

    protected void playCloseSound(BlockState state) {
        double d0 = (double)this.worldPosition.getX() + 0.5;
        double d1 = (double)this.worldPosition.getY() + 1.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5;
        this.level.playSound(null, d0, d1, d2, ModSounds.LUNCH_BASKET_CLOSE.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.8f);
    }

    protected void updateBlockState(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)LunchBoxBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public AbstractContainerMenu createMenu(int id, Inventory player) {
        return new VariableSizeContainerMenu(ModMenuTypes.LUNCH_BASKET.get(), id, player, (Container)this, this.getContainerSize());
    }

    public boolean isSlotUnlocked(int ind) {
        return ind < this.getContainerSize();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.isSlotUnlocked(index) && LunchBoxItem.canAcceptItem(stack);
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return this.isSlotUnlocked(index);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.dyeColor != null) {
            Tag t = (Tag)DyedItemColor.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.dyeColor).getOrThrow();
            tag.put("Color", t);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        Tag t = tag.get("Color");
        if (t != null) {
            this.dyeColor = (DyedItemColor)((Pair)DyedItemColor.CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)t).getOrThrow()).getFirst();
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        LunchBaskedContent content = (LunchBaskedContent)componentInput.get(ModComponents.LUNCH_BASKET_CONTENT.get());
        if (content != null) {
            for (int i = 0; i < this.getContainerSize(); ++i) {
                this.setItem(i, content.getStackInSlot(i));
            }
        }
        this.dyeColor = (DyedItemColor)componentInput.get(DataComponents.DYED_COLOR);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        LunchBaskedContent.Mutable content = LunchBaskedContent.empty(this.getContainerSize()).toMutable();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            content.setStackInSlot(i, this.getItem(i));
        }
        components.set(ModComponents.LUNCH_BASKET_CONTENT.get(), (Object)content.toImmutable());
        if (this.dyeColor != null) {
            components.set(DataComponents.DYED_COLOR, (Object)this.dyeColor);
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("Items");
    }

    @Nullable
    public DyedItemColor getDyedColor() {
        return this.dyeColor;
    }

    public void setDyedColor(DyedItemColor o) {
        this.dyeColor = o;
    }
}

