/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;

public class DrippingLiquidParticle
extends TextureSheetParticle {
    private DrippingLiquidParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.gravity *= 0.02f;
        this.lifetime = 40;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.ageParticle();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.updateMotion();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
                BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
                FluidState fluidstate = this.level.getFluidState(blockpos);
                if (!fluidstate.isEmpty() && this.y < (double)((float)blockpos.getY() + fluidstate.getHeight((BlockGetter)this.level, blockpos))) {
                    this.remove();
                }
            }
        }
    }

    protected void ageParticle() {
        if (this.lifetime-- <= 0) {
            this.remove();
            this.level.addParticle((ParticleOptions)ModParticles.FALLING_LIQUID.get(), this.x, this.y, this.z, (double)this.rCol, (double)this.gCol, (double)this.bCol);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    protected void updateMotion() {
        this.xd *= 0.02;
        this.yd *= 0.02;
        this.zd *= 0.02;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double r, double g, double b) {
            DrippingLiquidParticle drippingLiquidParticle = new DrippingLiquidParticle(worldIn, x, y, z);
            drippingLiquidParticle.setColor((float)r, (float)g, (float)b);
            drippingLiquidParticle.pickSprite(this.spriteSet);
            return drippingLiquidParticle;
        }
    }
}

