/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;

public class SuctionParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Vec3 initialVelocity;
    private final float ACCELERATION_FACTOR = 5.0f;

    public SuctionParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
        super(level, x, y, z, vx, vy, vz);
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
        this.gravity = 0.0f;
        this.hasPhysics = false;
        this.lifetime = 15;
        this.alpha = 0.0f;
        this.initialVelocity = new Vec3(vx, vy, vz);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.roll = 10.0f;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        float progress = (float)this.age / (float)this.lifetime;
        float velocityMultiplier = 5.0f * (progress * progress);
        Vec3 newVelocity = this.initialVelocity.scale((double)velocityMultiplier);
        this.x += newVelocity.x;
        this.y += newVelocity.y;
        this.z += newVelocity.z;
        this.alpha = (double)progress < 0.5 ? progress : 0.5f - (progress - 0.5f);
        this.setAlpha(Math.max(0.0f, this.alpha / 1.5f));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new SuctionParticle(level, x, y, z, vx, vy, vz, this.sprites);
        }
    }
}

