/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials;

import com.structureessentials.IStructureModifier;
import com.structureessentials.Timings;
import com.structureessentials.command.Command;
import com.structureessentials.config.CommonConfiguration;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.ModifiableStructureInfo;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="structureessentials")
public class StructureEssentials {
    public static final String MODID = "structureessentials";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Random rand = new Random();

    public StructureEssentials(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::setup);
        NeoForge.EVENT_BUS.addListener(this::commandRegister);
    }

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register(new Command().build(event.getBuildContext()));
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("structureessentials mod initialized");
    }

    public static void onServerStart(MinecraftServer server) {
        Timings.featureTimings = new ConcurrentHashMap<ResourceLocation, Long>();
        Timings.structureTimings = new ConcurrentHashMap<ResourceLocation, Long>();
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        List holders = registryAccess.registryOrThrow(Registries.STRUCTURE).holders().toList();
        Registry biomeRegistry = (Registry)registryAccess.registry(Registries.BIOME).get();
        Registry structureSetRegistry = registryAccess.registryOrThrow(Registries.STRUCTURE_SET);
        if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).logDuplicatedSalt) {
            Int2ObjectOpenHashMap structureSetIds = new Int2ObjectOpenHashMap();
            for (Map.Entry entry : structureSetRegistry.entrySet()) {
                int salt = ((StructureSet)entry.getValue()).placement().salt();
                structureSetIds.putIfAbsent(salt, new HashSet());
                ((Set)structureSetIds.get(salt)).add(((ResourceKey)entry.getKey()).location().toString());
            }
            for (Map.Entry entry : structureSetIds.int2ObjectEntrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                LOGGER.warn("Non-unique structure_set salt:" + entry.getIntKey() + " potentially creating overlapping structures detected. Structure sets: " + String.valueOf(entry.getValue()));
            }
        }
        if (!((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompat) {
            return;
        }
        HashMap<ResourceLocation, TagKey> directReplacementTags = new HashMap<ResourceLocation, TagKey>();
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"deep_ocean"), BiomeTags.IS_DEEP_OCEAN);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"ocean"), BiomeTags.IS_OCEAN);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"river"), BiomeTags.IS_RIVER);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"badlands"), BiomeTags.IS_BADLANDS);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"eroded_badlands"), BiomeTags.IS_BADLANDS);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"wooded_badlands"), BiomeTags.IS_BADLANDS);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"windswept_hills"), BiomeTags.IS_HILL);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"windswept_gravelly_hills"), BiomeTags.IS_HILL);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"taiga"), BiomeTags.IS_TAIGA);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"jungle"), BiomeTags.IS_JUNGLE);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"forest"), BiomeTags.IS_FOREST);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"savanna"), BiomeTags.IS_SAVANNA);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"deep_dark"), BiomeTags.HAS_ANCIENT_CITY);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"plains"), Tags.Biomes.IS_PLAINS);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"snowy_plains"), Tags.Biomes.IS_SNOWY_PLAINS);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"desert"), Tags.Biomes.IS_DESERT);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"swamp"), Tags.Biomes.IS_SWAMP);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"flower_forest"), Tags.Biomes.IS_FLOWER_FOREST);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"birch_forest"), Tags.Biomes.IS_BIRCH_FOREST);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"old_growth_birch_forest"), Tags.Biomes.IS_OLD_GROWTH);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"old_growth_pine_taiga"), Tags.Biomes.IS_OLD_GROWTH);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"old_growth_spruce_taiga"), Tags.Biomes.IS_OLD_GROWTH);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"stony_shore"), Tags.Biomes.IS_STONY_SHORES);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"mushroom_fields"), Tags.Biomes.IS_MUSHROOM);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"lush_caves"), Tags.Biomes.IS_LUSH);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"warped_forest"), Tags.Biomes.IS_NETHER_FOREST);
        directReplacementTags.put(ResourceLocation.withDefaultNamespace((String)"crimson_forest"), Tags.Biomes.IS_NETHER_FOREST);
        Set<TagKey> DEFINING_TAGS = Set.of(BiomeTags.IS_RIVER, BiomeTags.IS_DEEP_OCEAN, BiomeTags.IS_OCEAN, BiomeTags.IS_BEACH, BiomeTags.IS_BADLANDS, BiomeTags.IS_SAVANNA, BiomeTags.IS_TAIGA, BiomeTags.IS_JUNGLE, BiomeTags.IS_FOREST, BiomeTags.IS_MOUNTAIN, StructureEssentials.createBiomeTag("forge", "is_cave"), StructureEssentials.createBiomeTag("forge", "is_plains"), StructureEssentials.createBiomeTag("forge", "is_desert"), StructureEssentials.createBiomeTag("forge", "is_snowy"), StructureEssentials.createBiomeTag("forge", "is_lush"), StructureEssentials.createBiomeTag("forge", "is_dead"), StructureEssentials.createBiomeTag("forge", "is_underground"), StructureEssentials.createBiomeTag("forge", "is_void"), StructureEssentials.createBiomeTag("forge", "is_sandy"), StructureEssentials.createBiomeTag("forge", "is_swamp"), StructureEssentials.createBiomeTag("c", "no_default_monsters"), StructureEssentials.createBiomeTag("c", "is_void"), StructureEssentials.createBiomeTag("c", "is_dense_vegetation"), StructureEssentials.createBiomeTag("c", "is_sparse_vegetation"), StructureEssentials.createBiomeTag("c", "is_plains"), StructureEssentials.createBiomeTag("c", "is_windswept"), StructureEssentials.createBiomeTag("c", "is_shallow_ocean"), StructureEssentials.createBiomeTag("c", "is_underground"), StructureEssentials.createBiomeTag("c", "is_cave"), StructureEssentials.createBiomeTag("c", "is_lush"), StructureEssentials.createBiomeTag("c", "is_dead"), StructureEssentials.createBiomeTag("c", "is_sandy"), StructureEssentials.createBiomeTag("c", "is_snowy"), StructureEssentials.createBiomeTag("c", "is_icy"), StructureEssentials.createBiomeTag("c", "is_swamp"), StructureEssentials.createBiomeTag("c", "is_aquatic"));
        for (Holder.Reference holder : holders) {
            Object2DoubleMap.Entry scoredBiome;
            Object entry;
            Object biome22;
            LinkedHashSet<Object> biomeHolderSet = new LinkedHashSet<Object>(((Structure)holder.value()).biomes().size());
            float minTemp = 1000.0f;
            float maxTemp = -1000.0f;
            float maxDownfall = -1000.0f;
            float minDownfall = 1000.0f;
            Object2IntOpenHashMap allowedDefiningTags = new Object2IntOpenHashMap();
            for (Object biome22 : ((Structure)holder.value()).biomes()) {
                float downFall;
                if (!holder.isBound()) continue;
                biomeHolderSet.add(biome22);
                float temp = Command.getAdjustedTemp((Holder<Biome>)biome22);
                if (temp < minTemp) {
                    minTemp = temp;
                }
                if (temp > maxTemp) {
                    maxTemp = temp;
                }
                if ((downFall = ((Biome)biome22.value()).getModifiedClimateSettings().downfall()) < minDownfall) {
                    minDownfall = downFall;
                }
                if (downFall > maxDownfall) {
                    maxDownfall = downFall;
                }
                for (TagKey biomeTagKey : DEFINING_TAGS) {
                    if (!biome22.is(biomeTagKey)) continue;
                    allowedDefiningTags.put((Object)biomeTagKey, allowedDefiningTags.getOrDefault((Object)biomeTagKey, 0) + 1);
                }
            }
            HashSet<TagKey> deniedDefiningSet = new HashSet<TagKey>();
            biome22 = DEFINING_TAGS.iterator();
            while (biome22.hasNext()) {
                TagKey biomeTagKey = (TagKey)biome22.next();
                if (allowedDefiningTags.containsKey((Object)biomeTagKey)) continue;
                deniedDefiningSet.add(biomeTagKey);
            }
            HashSet<TagKey> requiredDefiningSet = new HashSet<TagKey>();
            for (Object2IntMap.Entry entry2 : allowedDefiningTags.object2IntEntrySet()) {
                if (entry2.getIntValue() != ((Structure)holder.value()).biomes().size()) continue;
                requiredDefiningSet.add((TagKey)entry2.getKey());
            }
            if (biomeHolderSet.isEmpty()) continue;
            minTemp -= 0.35f;
            maxTemp += 0.35f;
            minDownfall -= 0.35f;
            maxDownfall += 0.35f;
            HashMap<ServerLevel, Set> allowedDimensions = new HashMap<ServerLevel, Set>();
            for (ServerLevel level : server.getAllLevels()) {
                Set dimensionbiomes = level.getChunkSource().getGenerator().getBiomeSource().possibleBiomes();
                allowedDimensions.put(level, dimensionbiomes);
            }
            Iterator iterator = allowedDimensions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry dimensionBiomes = iterator.next();
                boolean contained = false;
                for (Holder holder2 : biomeHolderSet) {
                    if (!((Set)dimensionBiomes.getValue()).contains(holder2)) continue;
                    contained = true;
                    break;
                }
                if (contained && ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).dimensionWhitelist.contains(((ServerLevel)dimensionBiomes.getKey()).dimension().location().toString())) continue;
                iterator.remove();
            }
            HashSet<TagKey> addedTags = new HashSet<TagKey>(requiredDefiningSet);
            HashSet<Holder> addedTagBiomes = new HashSet<Holder>();
            HashSet<Holder> toAdd = new HashSet<Holder>();
            for (TagKey tagKey : requiredDefiningSet) {
                for (Holder holder3 : biomeRegistry.getOrCreateTag(tagKey)) {
                    if (biomeHolderSet.contains(holder3)) continue;
                    toAdd.add(holder3);
                }
            }
            for (Holder holder4 : biomeHolderSet) {
                TagKey tag2 = (TagKey)directReplacementTags.get(biomeRegistry.getKey((Object)((Biome)holder4.value())));
                if (tag2 == null || addedTags.contains(tag2) || !holder4.is(tag2)) continue;
                for (Holder tagBiome2 : biomeRegistry.getOrCreateTag(tag2)) {
                    if (biomeHolderSet.contains(tagBiome2)) continue;
                    toAdd.add(tagBiome2);
                    addedTagBiomes.add(tagBiome2);
                }
                addedTags.add(tag2);
            }
            Object2DoubleOpenHashMap highScoreBiomes = new Object2DoubleOpenHashMap();
            Object2DoubleOpenHashMap object2DoubleOpenHashMap = new Object2DoubleOpenHashMap();
            for (Holder holder5 : biomeHolderSet) {
                List<Object2DoubleMap.Entry<Holder<Biome>>> similar = Command.getSimilarBiomesFor((Holder<Biome>)holder5, (RegistryAccess)registryAccess);
                for (int i = 0; i < similar.size() && i < 200; ++i) {
                    entry = similar.get(i);
                    if (biomeHolderSet.contains(entry.getKey())) continue;
                    double percent = entry.getDoubleValue();
                    double previousValue = object2DoubleOpenHashMap.getOrDefault(entry.getKey(), 0.0);
                    double d = toAdd.contains(entry.getKey()) ? 0.7224999999999999 : 0.85;
                    if (percent >= d * ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatStrictness) {
                        highScoreBiomes.put((Object)((Holder)entry.getKey()), percent);
                    }
                    object2DoubleOpenHashMap.put((Object)((Holder)entry.getKey()), previousValue + percent);
                }
            }
            for (Object2DoubleMap.Entry entry2 : object2DoubleOpenHashMap.object2DoubleEntrySet()) {
                entry2.setValue(entry2.getDoubleValue() / (double)biomeHolderSet.size());
            }
            if (highScoreBiomes.isEmpty()) continue;
            ArrayList<Object> sortedPotentialBiomes = new ArrayList<Object>((Collection<Object>)object2DoubleOpenHashMap.object2DoubleEntrySet());
            sortedPotentialBiomes.sort(Comparator.comparingDouble(e -> ((Object2DoubleMap.Entry)e).getDoubleValue()).reversed());
            Object2DoubleMap.Entry entry3 = (Object2DoubleMap.Entry)sortedPotentialBiomes.get(0);
            if (entry3 == null) continue;
            toAdd.clear();
            double minSimilarity = entry3.getDoubleValue() * 0.8 * ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatStrictness;
            entry = sortedPotentialBiomes.iterator();
            while (entry.hasNext() && !((scoredBiome = (Object2DoubleMap.Entry)entry.next()).getDoubleValue() < minSimilarity)) {
                if (!highScoreBiomes.containsKey(scoredBiome.getKey())) continue;
                toAdd.add((Holder)scoredBiome.getKey());
            }
            Iterator iterator2 = toAdd.iterator();
            block18: while (iterator2.hasNext()) {
                Holder biomeHolder = (Holder)iterator2.next();
                if (!biomeHolder.isBound() || biomeHolder.unwrapKey().isEmpty()) {
                    iterator2.remove();
                    continue;
                }
                ResourceKey biomeKey = (ResourceKey)biomeHolder.unwrapKey().get();
                if (biomeKey == Biomes.THE_END || biomeKey == Biomes.THE_VOID || biomeKey == Biomes.SMALL_END_ISLANDS) {
                    iterator2.remove();
                    continue;
                }
                boolean containedDimension = false;
                for (Set dimensionBiomes : allowedDimensions.values()) {
                    if (!dimensionBiomes.contains(biomeHolder)) continue;
                    containedDimension = true;
                    break;
                }
                if (!containedDimension) {
                    iterator2.remove();
                    continue;
                }
                if (((Biome)biomeHolder.value()).getGenerationSettings().features().isEmpty()) {
                    iterator2.remove();
                    continue;
                }
                float temp = Command.getAdjustedTemp((Holder<Biome>)biomeHolder);
                float downFall = ((Biome)biomeHolder.value()).getModifiedClimateSettings().downfall();
                if (!(temp > minTemp && temp < maxTemp && downFall < maxDownfall && downFall > minDownfall)) {
                    iterator2.remove();
                    continue;
                }
                if (!biomeHolder.tags().anyMatch(tag -> tag.location().getPath().contains("structure"))) {
                    iterator2.remove();
                    continue;
                }
                boolean shouldRemove = false;
                for (TagKey biomeTagKey : requiredDefiningSet) {
                    if (biomeHolder.is(biomeTagKey) || addedTagBiomes.contains(biomeHolder)) continue;
                    shouldRemove = true;
                }
                if (shouldRemove) {
                    iterator2.remove();
                    continue;
                }
                for (TagKey biomeTagKey : deniedDefiningSet) {
                    if (!biomeHolder.is(biomeTagKey)) continue;
                    iterator2.remove();
                    continue block18;
                }
            }
            if (toAdd.isEmpty()) continue;
            String tagName = biomeRegistry.getKey((Object)((Biome)((Holder)((Structure)holder.value()).biomes().iterator().next()).value())).toString();
            if (((Structure)holder.value()).biomes().unwrap().left().isPresent()) {
                tagName = ((TagKey)((Structure)holder.value()).biomes().unwrap().left().get()).location().toString();
            }
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatLogging) {
                LOGGER.warn("Adding Biomes to structure: " + String.valueOf(holder.key().location()) + " tag:" + tagName + " mins:" + (double)((int)(minSimilarity * 1000.0)) / 1000.0 + " biomes: " + String.valueOf(toAdd.stream().map(e -> String.valueOf(((ResourceKey)e.unwrapKey().get()).location()) + ":" + (double)((int)(potentialBiomes.getOrDefault(e, 0.0) * 1000.0)) / 1000.0).toList()));
            }
            biomeHolderSet.addAll(toAdd);
            ModifiableStructureInfo modifiableStructureInfo = ((Structure)holder.value()).modifiableStructureInfo();
            if (!(modifiableStructureInfo instanceof IStructureModifier)) continue;
            IStructureModifier structureModifier = (IStructureModifier)modifiableStructureInfo;
            structureModifier.setStructureBiomes((HolderSet<Biome>)HolderSet.direct(new ArrayList(biomeHolderSet)));
        }
        Command.biomeScoreCache.clear();
    }

    public static ResourceLocation createResourcelocation(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static TagKey<Biome> createBiomeTag(String namespace, String path) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)StructureEssentials.createResourcelocation(namespace, path));
    }
}

