/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.TrainDebugViewer;
import de.mrjulsen.crn.debug.TrainDebugData;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TrainDebugWidget
extends DLButton {
    public static final int HEADER_HEIGHT = 20;
    public static final int DEFAULT_LINE_HEIGHT = 12;
    public static final float DEFAULT_SCALE = 0.75f;
    private final TrainDebugData data;

    public TrainDebugWidget(Screen parent, TrainDebugViewer viewer, int x, int y, int width, TrainDebugData data) {
        super(x, y, width, 32, (Component)TextUtils.empty(), b -> {});
        this.data = data;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)this), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.text((String)"Reset Predictions"), Sprite.empty(), true, b -> DataAccessor.getFromServer((Object)data.trainId(), ModAccessorTypes.TRAIN_SOFT_RESET, $ -> viewer.reload()), null)).addSeparator().add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.text((String)"Hard Reset"), Sprite.empty(), true, b -> DataAccessor.getFromServer((Object)data.trainId(), ModAccessorTypes.TRAIN_HARD_RESET, $ -> viewer.reload()), null))));
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ColorShade.DARK.getColor());
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)0x22FFFFFF);
        }
        float scale = 0.75f;
        MutableComponent trainName = TextUtils.text((String)this.data.trainName()).withStyle(ChatFormatting.BOLD);
        graphics.poseStack().pushPose();
        graphics.poseStack().translate((float)this.x(), (float)this.y(), 0.0f);
        graphics.poseStack().scale(0.75f, 0.75f, 0.75f);
        MutableComponent predictionsText = TextUtils.text((String)(this.data.predictionsInitialized() + " / " + this.data.predictionsCount()));
        int platformTextWidth = this.font.width((FormattedText)predictionsText);
        CreateDynamicWidgets.renderTextHighlighted(graphics, 5, 4, this.font, (Component)trainName, -13027015);
        int maxIdWidth = (int)((float)this.width() - (float)platformTextWidth * 0.75f - 15.0f - (float)(45 + this.font.width((FormattedText)trainName)) * 0.75f);
        MutableComponent idText = TextUtils.text((String)this.data.trainId().toString());
        if (this.font.width((FormattedText)idText) > maxIdWidth) {
            idText = TextUtils.text((String)this.font.substrByWidth((FormattedText)idText, maxIdWidth).getString()).append((Component)TextUtils.text((String)"...")).withStyle(idText.getStyle());
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(20 + this.font.width((FormattedText)trainName)), (int)6, (FormattedText)idText, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)this.width() / 0.75f) - 6), (int)6, (FormattedText)predictionsText, (int)0xFFFFFF, (EAlignment)EAlignment.RIGHT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)5, (int)20, (FormattedText)TextUtils.text((String)("Session: " + String.valueOf(this.data.sessionId()))), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)5, (int)30, (FormattedText)TextUtils.text((String)("Status: " + this.data.state().getName())), (int)this.data.state().getColor(), (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().popPose();
    }
}

