/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IStaticTextSetting;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;

public class SimpleStaticTextDisplaySettings
extends BasicDisplaySettings
implements IStaticTextSetting {
    protected String staticText = "Hello World";

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.contains("StaticText")) {
            this.staticText = nbt.getString("StaticText");
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.putString("StaticText", this.staticText);
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildStaticTextGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyStaticTextSettings(oldSettings);
    }

    @Override
    public String getStaticText() {
        return this.staticText == null ? "" : this.staticText;
    }

    @Override
    public void setStaticText(String text) {
        this.staticText = text;
    }
}

