/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.events;

import com.pyzpre.createbitterballen.block.sunflower.SunflowerStem;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.pyzpre.createbitterballen.index.EffectRegistry;
import com.pyzpre.createbitterballen.index.FluidRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityEffectHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean isInitialized = false;

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            for (Player player : level.players()) {
                BlockPos playerPos = player.blockPosition();
                AABB dynamicBounds = new AABB((double)(playerPos.getX() - 16), (double)(playerPos.getY() - 16), (double)(playerPos.getZ() - 16), (double)(playerPos.getX() + 16), (double)(playerPos.getY() + 16), (double)(playerPos.getZ() + 16));
                for (Entity entity : level.getEntities(null, dynamicBounds)) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || !this.isInFryingOil(living = (LivingEntity)entity, level)) continue;
                    this.applyOilEffect(living);
                }
            }
        }
    }

    private boolean isInFryingOil(LivingEntity entity, Level level) {
        BlockPos pos = entity.blockPosition();
        FluidState fluidState = level.getFluidState(pos);
        Fluid fluid = fluidState.getType();
        boolean isFryingOil = fluid.isSame((Fluid)FluidRegistry.FRYING_OIL.get());
        return isFryingOil;
    }

    private void applyOilEffect(LivingEntity entity) {
        MobEffectInstance oiledup = new MobEffectInstance(EffectRegistry.OILED_UP, 200, 1);
        if (!entity.hasEffect(EffectRegistry.OILED_UP)) {
            entity.addEffect(oiledup);
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            chicken.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)chicken, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).asItem()}), false));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getLevel().isClientSide()) {
            Entity target = event.getTarget();
            Player player = event.getEntity();
            ItemStack heldItem = player.getItemInHand(event.getHand());
            if (target instanceof Chicken) {
                Chicken chicken = (Chicken)target;
                if (heldItem.getItem() == ((SunflowerStem)((Object)BlockRegistry.SUNFLOWERSTEM.get())).asItem() && chicken.isAlive() && !chicken.isBaby() && !chicken.isInLove()) {
                    if (!player.getAbilities().instabuild) {
                        heldItem.shrink(1);
                    }
                    chicken.setInLove(player);
                    player.swing(event.getHand(), true);
                    Level level = player.level();
                    level.broadcastEntityEvent((Entity)chicken, (byte)18);
                    event.setCanceled(true);
                }
            }
        }
    }
}

