/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.sunflower;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SunflowerStem
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public SunflowerStem(BlockBehaviour.Properties properties) {
        super(properties.offsetType(BlockBehaviour.OffsetType.XZ));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
    }

    private boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE) >= 3;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && !this.isMaxAge(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Vec3 offset = state.getOffset(level, pos);
        int age = (Integer)state.getValue((Property)AGE);
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
        return (switch (age) {
            case 0 -> Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.3125, (double)0.6875);
            case 1 -> Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875);
            case 2 -> {
                if (half == DoubleBlockHalf.LOWER) {
                    yield Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
                }
                yield Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
            }
            case 3 -> {
                if (half == DoubleBlockHalf.LOWER) {
                    yield Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
                }
                yield Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
            }
            default -> Shapes.block();
        }).move(offset.x, offset.y, offset.z);
    }

    public static VoxelShape makeShape() {
        return Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextInt(100) != 0) {
            return;
        }
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            BlockPos upperPartPos;
            boolean AboveBlockRemoved;
            int currentAge = (Integer)state.getValue((Property)AGE);
            if (currentAge < 3) {
                int newAge = currentAge + 1;
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge)));
                if (newAge == 2 && world.isEmptyBlock(pos.above())) {
                    world.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
                }
            }
            if (currentAge == 2 && (AboveBlockRemoved = world.setBlock(upperPartPos = pos.above(), Blocks.AIR.defaultBlockState(), 18))) {
                DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)Blocks.SUNFLOWER.defaultBlockState(), (BlockPos)pos, (int)18);
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            return !this.isMaxAge(state);
        }
        BlockState lowerPartState = world.getBlockState(pos.below());
        return lowerPartState.getBlock() == this && !this.isMaxAge(lowerPartState);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            this.growStemOrSunflower(world, pos, state);
        } else {
            BlockPos lowerPartPos = pos.below();
            BlockState lowerPartState = world.getBlockState(lowerPartPos);
            if (lowerPartState.getBlock() == this) {
                this.growStemOrSunflower(world, lowerPartPos, lowerPartState);
            }
        }
    }

    private void growStemOrSunflower(ServerLevel world, BlockPos pos, BlockState state) {
        boolean isAboveBlockRemoved;
        int currentAge = (Integer)state.getValue((Property)AGE);
        if (currentAge < 3) {
            int newAge = currentAge + 1;
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge)));
            if (newAge == 2 && world.isEmptyBlock(pos.above())) {
                world.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
            }
        }
        if (currentAge == 2 && (isAboveBlockRemoved = world.removeBlock(pos.above(), false))) {
            DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)Blocks.SUNFLOWER.defaultBlockState(), (BlockPos)pos, (int)3);
        }
    }
}

