/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.automessage;

import java.io.File;
import java.util.Objects;
import neoforge.com.cursee.automessage.Constants;
import neoforge.com.cursee.automessage.core.message.ClientMessageService;
import neoforge.com.cursee.automessage.core.message.util.MessageType;
import neoforge.com.cursee.automessage.core.util.JsonFileHelper;
import neoforge.com.cursee.automessage.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class AutoMessageClient {
    static Minecraft CLIENT;
    private static final String AUTOMESSAGE_DATA_DIR_FILEPATH;
    private static final String CLIENT_SERVER_TAGS_FILEPATH;

    public static void init(Minecraft client) {
        CLIENT = client;
        ClientMessageService.load();
        File autoMessageDataDirectory = new File(AUTOMESSAGE_DATA_DIR_FILEPATH);
        if (!autoMessageDataDirectory.isDirectory()) {
            autoMessageDataDirectory.mkdirs();
        }
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "World Name", "your_message_identifier.firstJoin");
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "127.0.0.1", "your_message_identifier.firstJoin");
    }

    public static void onFirstJoinLevel(LocalPlayer player, ClientLevel level) {
        if (level == null || !ClientMessageService.instance.general.enabled) {
            return;
        }
        ClientMessageService.instance.ON_FIRST_JOIN_MESSAGES.forEach(message -> {
            String serverName;
            if (CLIENT.hasSingleplayerServer()) {
                MinecraftServer server = (MinecraftServer)Objects.requireNonNull(CLIENT.getSingleplayerServer());
                serverName = server.getWorldPath(LevelResource.PLAYER_DATA_DIR).toString();
                serverName = serverName.replaceAll("(?s)^.*?(?=" + server.getWorldData().getLevelName() + ")", "").replace(File.separatorChar + "playerdata", "");
            } else {
                serverName = Objects.requireNonNull(AutoMessageClient.CLIENT.getCurrentServer()).ip;
            }
            if (message.pack_intro && JsonFileHelper.anyKeyContainsTag(new File(CLIENT_SERVER_TAGS_FILEPATH), message.identifier + ".firstJoin")) {
                return;
            }
            if (JsonFileHelper.hasKey(CLIENT_SERVER_TAGS_FILEPATH, serverName)) {
                Constants.LOG.info("Client had key {}, so tags that were already generated are being checked.", (Object)serverName);
            }
            boolean hasTag = JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + ".firstJoin");
            if (message.repeats || !hasTag) {
                if (message.type == MessageType.CHAT) {
                    if (message.link != null && !message.link.isEmpty()) {
                        player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString()).replace("%link%", message.link)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, message.link))));
                    } else {
                        player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())));
                    }
                } else {
                    player.displayClientMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())), true);
                }
                if (!message.repeats && !hasTag) {
                    JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + ".firstJoin");
                }
            }
        });
    }

    public static void onJoinLevel(LocalPlayer player, ClientLevel level) {
        if (level == null || !ClientMessageService.instance.general.enabled) {
            return;
        }
        ClientMessageService.instance.ON_JOIN_LEVEL_MESSAGES.forEach(message -> {
            if (message.type == MessageType.CHAT) {
                if (message.link != null && !message.link.isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString()).replace("%link%", message.link)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, message.link))));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())));
                }
            } else {
                player.displayClientMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())), true);
            }
        });
    }

    public static void onDeath(Player player) {
        ClientMessageService.instance.ON_DEATH_MESSAGES.forEach(message -> {
            if (message.type == MessageType.CHAT) {
                if (message.link != null && !message.link.isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString()).replace("%link%", message.link)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, message.link))));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())));
                }
            } else {
                player.displayClientMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())), true);
            }
        });
    }

    public static void onRespawn(LocalPlayer player) {
        ClientMessageService.instance.ON_RESPAWN_MESSAGES.forEach(message -> {
            if (message.type == MessageType.CHAT) {
                if (message.link != null && !message.link.isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString()).replace("%link%", message.link)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, message.link))));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())));
                }
            } else {
                player.displayClientMessage((Component)Component.literal((String)message.text.replace("%player%", player.getDisplayName().getString())), true);
            }
        });
    }

    static {
        AUTOMESSAGE_DATA_DIR_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data";
        CLIENT_SERVER_TAGS_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data" + File.separator + "client_server_tags.json";
    }
}

