/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.registry;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class SlabRegistry {
    private static final List<SlabRegistryData> slabRegistry = new ArrayList<SlabRegistryData>();
    private static final Map<Block, SlabConverter> slabMap = new HashMap<Block, SlabConverter>();

    public static void registerSlabConverter(Block doubleSlab, SlabConverter converter) {
        slabMap.put(doubleSlab, converter);
    }

    public static void registerSlab(SlabRegistryData data) {
        try {
            Constructor<? extends SlabConverter> constructor = data.getConverterClass().getConstructor(new Class[0]);
            SlabConverter converter = constructor.newInstance(new Object[0]);
            SlabRegistry.registerSlabConverter(data.getDoubleSlab(), converter);
            slabRegistry.add(data);
        }
        catch (NoSuchMethodException e) {
            KleeSlabs.logger.error("Slab converter class does not have a no-arg constructor: {}", data.getConverterClass());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            KleeSlabs.logger.error("Slab converter class constructor invocation failed: {}", data.getConverterClass(), (Object)e);
        }
    }

    public static List<SlabRegistryData> getSlabEntries() {
        return slabRegistry;
    }

    @Nullable
    public static SlabConverter getSlabConverter(Block block) {
        return slabMap.get(block);
    }

    public static void clearRegistry() {
        slabRegistry.clear();
        slabMap.clear();
    }
}

