/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.portablespawner.mixin;

import fr.shoqapik.portablespawner.PortableSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpawnerBlock.class})
public class SpawnerBlockMixin {
    @Inject(at={@At(value="HEAD")}, method={"getExpDrop"}, cancellable=true)
    public void onStacksDropped(BlockState state, LevelAccessor level, BlockPos pos, BlockEntity blockEntity, Entity breaker, ItemStack tool, CallbackInfoReturnable<Integer> cir) {
        Block block = (Block)this;
        if (block instanceof SpawnerBlock) {
            Holder.Reference enchantmentHolder = level.holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
            if ((tool.getEnchantments().getLevel((Holder)enchantmentHolder) > 0 || !PortableSpawner.CONFIG.requireSilkTouch) && tool.getItem() instanceof PickaxeItem) {
                cir.setReturnValue((Object)0);
            }
        }
    }
}

