/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.portablespawner.mixin;

import fr.shoqapik.portablespawner.PortableSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class SBlockMixin {
    @Inject(at={@At(value="HEAD")}, method={"playerWillDestroy"})
    public void playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player, CallbackInfoReturnable<BlockState> cir) {
        Block block = (Block)this;
        if (block instanceof SpawnerBlock && world.getBlockEntity(pos) instanceof SpawnerBlockEntity) {
            ItemStack tool = player.getMainHandItem();
            Holder.Reference enchantmentHolder = world.holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
            if ((tool.getEnchantments().getLevel((Holder)enchantmentHolder) > 0 || !PortableSpawner.CONFIG.requireSilkTouch) && tool.getItem() instanceof PickaxeItem) {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                ItemStack itemStack = block.asItem().getDefaultInstance();
                blockEntity.saveToItem(itemStack, (HolderLookup.Provider)world.registryAccess());
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
                itemEntity.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)itemEntity);
            }
        }
    }
}

