/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayTerminalBlock
extends AbstractWalkwayBlock {
    public WalkwayTerminalBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CAPS_SHAFT, (Comparable)((Object)WalkwayCaps.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CAPS_SHAFT});
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        Direction leftFace = ((Direction)state.getValue(HORIZONTAL_FACING)).getCounterClockWise();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.getValue((Property)CAPS_SHAFT));
        return face == leftFace && !caps.hasLeftCap() || face == leftFace.getOpposite() && !caps.hasRightCap() || face == Direction.DOWN;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.getValue((Property)CAPS_SHAFT) == newState.getValue((Property)CAPS_SHAFT);
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return WalkwaySlope.TERMINAL;
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return true;
    }

    @Override
    public boolean movesEntities(BlockState state) {
        return false;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockState newState = state;
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        Direction left = facing.getCounterClockWise();
        Direction right = left.getOpposite();
        Direction clicked = context.getClickedFace();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.getValue((Property)CAPS_SHAFT));
        if (clicked == left) {
            caps = caps.toggleLeft();
        }
        if (clicked == right) {
            caps = caps.toggleRight();
        }
        newState = (BlockState)newState.setValue((Property)CAPS_SHAFT, (Comparable)((Object)caps));
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(newState, context));
        BlockState setState = level.getBlockState(context.getClickedPos());
        if (setState != state) {
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)context.getClickedPos(), 1.0f, level.random.nextFloat() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        if (remove) {
            return state;
        }
        WalkwayCaps caps = (WalkwayCaps)((Object)state.getValue((Property)CAPS_SHAFT));
        if (replace) {
            if (left && caps.hasRightCap()) {
                caps = caps.toggleRight();
            } else if (!left && caps.hasLeftCap()) {
                caps = caps.toggleLeft();
            }
        } else if (left && caps.hasRightCap()) {
            caps = caps.toggleRight();
        } else if (!left && caps.hasLeftCap()) {
            caps = caps.toggleLeft();
        }
        return (BlockState)state.setValue((Property)CAPS_SHAFT, (Comparable)((Object)caps));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        if (face == facing) {
            return true;
        }
        if (face == facing.getOpposite()) {
            return false;
        }
        BlockPos otherPos = pos.relative(facing);
        BlockState otherState = level.getBlockState(otherPos);
        Block block = otherState.getBlock();
        if (block instanceof WalkwayBlock) {
            WalkwayBlock walkway = (WalkwayBlock)block;
            if (!(otherState.getBlock() instanceof WalkwayTerminalBlock) && walkway.connectedToWalkwayOnSide(level, otherState, otherPos, face)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        BlockPos otherPos = pos.relative(facing);
        BlockState otherState = level.getBlockState(otherPos);
        Block block = otherState.getBlock();
        if (!(block instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkway = (WalkwayBlock)block;
        if (walkway.getWalkwaySlope(otherState) == WalkwaySlope.TERMINAL) {
            return false;
        }
        return walkway.isEscalator(level, state, pos);
    }
}

