/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.inventorybridge;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.content.inventoryaccessport.WrappedItemHandler;
import com.hlysine.create_connected.content.inventorybridge.InventoryBridgeBlock;
import com.hlysine.create_connected.content.inventorybridge.InventoryBridgeFilterSlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.List;
import java.util.function.Supplier;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="create_connected")
public class InventoryBridgeBlockEntity
extends SmartBlockEntity {
    protected IItemHandler itemCapability = null;
    private InvManipulationBehaviour negativeInventory;
    private InvManipulationBehaviour positiveInventory;
    SidedFilteringBehaviour filters;
    public FilteringBehaviour negativeFilter;
    public FilteringBehaviour positiveFilter;
    private boolean powered = false;

    public InventoryBridgeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.updateConnectedInventory();
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CCBlockEntityTypes.INVENTORY_BRIDGE.get(), (be, context) -> {
            if (be.itemCapability == null) {
                be.refreshCapability();
            }
            return be.itemCapability;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing1 = (w, p, s) -> new BlockFace(p, InventoryBridgeBlock.getNegativeTarget(s));
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing2 = (w, p, s) -> new BlockFace(p, InventoryBridgeBlock.getPositiveTarget(s));
        this.negativeInventory = new InvManipulationBehaviour((SmartBlockEntity)this, towardBlockFacing1);
        behaviours.add((BlockEntityBehaviour)this.negativeInventory);
        this.positiveInventory = new InvManipulationBehaviour((SmartBlockEntity)this, towardBlockFacing2);
        behaviours.add((BlockEntityBehaviour)this.positiveInventory);
        this.filters = new SidedFilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform.Sided)new InventoryBridgeFilterSlot(), (facing, filter) -> {
            if (facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                this.negativeFilter = filter;
            } else {
                this.positiveFilter = filter;
            }
            return filter;
        }, facing -> facing.getAxis() == this.getBlockState().getValue(InventoryBridgeBlock.AXIS));
        behaviours.add((BlockEntityBehaviour)this.filters);
    }

    public boolean isAttachedNegative() {
        return !this.powered && this.negativeInventory.hasInventory() && !(this.negativeInventory.getInventory() instanceof WrappedItemHandler);
    }

    public boolean isAttachedPositive() {
        return !this.powered && this.positiveInventory.hasInventory() && !(this.positiveInventory.getInventory() instanceof WrappedItemHandler);
    }

    public void updateConnectedInventory() {
        this.negativeInventory.findNewCapability();
        this.positiveInventory.findNewCapability();
        boolean previouslyPowered = this.powered;
        this.powered = this.level.hasNeighborSignal(this.worldPosition);
        if (this.powered != previouslyPowered) {
            this.notifyUpdate();
        }
        boolean attachedNegative = this.isAttachedNegative();
        boolean attachedPositive = this.isAttachedPositive();
        if (attachedNegative != (Boolean)this.getBlockState().getValue((Property)InventoryBridgeBlock.ATTACHED_NEGATIVE) || attachedPositive != (Boolean)this.getBlockState().getValue((Property)InventoryBridgeBlock.ATTACHED_POSITIVE)) {
            BlockState state = (BlockState)((BlockState)this.getBlockState().setValue((Property)InventoryBridgeBlock.ATTACHED_NEGATIVE, (Comparable)Boolean.valueOf(attachedNegative))).setValue((Property)InventoryBridgeBlock.ATTACHED_POSITIVE, (Comparable)Boolean.valueOf(attachedPositive));
            this.level.setBlockAndUpdate(this.worldPosition, state);
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.powered = tag.getBoolean("Powered");
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putBoolean("Powered", this.powered);
    }

    private IItemHandler getNegativeHandler() {
        if (this.powered) {
            return null;
        }
        IItemHandler handler = (IItemHandler)this.negativeInventory.getInventory();
        if (handler instanceof WrappedItemHandler) {
            return null;
        }
        return handler;
    }

    private IItemHandler getPositiveHandler() {
        if (this.powered) {
            return null;
        }
        IItemHandler handler = (IItemHandler)this.positiveInventory.getInventory();
        if (handler instanceof WrappedItemHandler) {
            return null;
        }
        return handler;
    }

    private void refreshCapability() {
        this.itemCapability = new InventoryBridgeHandler();
        this.invalidateCapabilities();
    }

    private class InventoryBridgeHandler
    implements WrappedItemHandler {
        private final ThreadLocal<Boolean> recursionGuard = ThreadLocal.withInitial(() -> false);

        private InventoryBridgeHandler() {
        }

        private <T> T preventRecursion(Supplier<T> value, T defaultValue) {
            if (this.recursionGuard.get().booleanValue()) {
                return defaultValue;
            }
            this.recursionGuard.set(true);
            T result = value.get();
            this.recursionGuard.set(false);
            return result;
        }

        public int getSlots() {
            return this.preventRecursion(() -> {
                IItemHandler handler1 = InventoryBridgeBlockEntity.this.getNegativeHandler();
                IItemHandler handler2 = InventoryBridgeBlockEntity.this.getPositiveHandler();
                if (handler1 == null && handler2 == null) {
                    return 0;
                }
                if (handler1 == null) {
                    return handler2.getSlots();
                }
                if (handler2 == null) {
                    return handler1.getSlots();
                }
                return handler1.getSlots() + handler2.getSlots();
            }, 0);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.preventRecursion(() -> {
                IItemHandler handler1 = InventoryBridgeBlockEntity.this.getNegativeHandler();
                IItemHandler handler2 = InventoryBridgeBlockEntity.this.getPositiveHandler();
                if (handler1 == null && handler2 == null) {
                    return ItemStack.EMPTY;
                }
                if (handler1 == null) {
                    return handler2.getStackInSlot(slot);
                }
                if (handler2 == null) {
                    return handler1.getStackInSlot(slot);
                }
                int size1 = handler1.getSlots();
                return slot < size1 ? handler1.getStackInSlot(slot) : handler2.getStackInSlot(slot - size1);
            }, ItemStack.EMPTY);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.preventRecursion(() -> {
                IItemHandler handler1 = InventoryBridgeBlockEntity.this.getNegativeHandler();
                IItemHandler handler2 = InventoryBridgeBlockEntity.this.getPositiveHandler();
                if (handler1 == null && handler2 == null) {
                    return stack;
                }
                if (handler1 == null) {
                    boolean negative = InventoryBridgeBlockEntity.this.negativeFilter.test(stack);
                    boolean positive = InventoryBridgeBlockEntity.this.positiveFilter.test(stack);
                    if (!positive) {
                        return stack;
                    }
                    if (negative && !InventoryBridgeBlockEntity.this.negativeFilter.getFilter().isEmpty() && InventoryBridgeBlockEntity.this.positiveFilter.getFilter().isEmpty()) {
                        return stack;
                    }
                    return handler2.insertItem(slot, stack, simulate);
                }
                if (handler2 == null) {
                    boolean negative = InventoryBridgeBlockEntity.this.negativeFilter.test(stack);
                    boolean positive = InventoryBridgeBlockEntity.this.positiveFilter.test(stack);
                    if (!negative) {
                        return stack;
                    }
                    if (positive && !InventoryBridgeBlockEntity.this.positiveFilter.getFilter().isEmpty() && InventoryBridgeBlockEntity.this.negativeFilter.getFilter().isEmpty()) {
                        return stack;
                    }
                    return handler1.insertItem(slot, stack, simulate);
                }
                boolean negative = InventoryBridgeBlockEntity.this.negativeFilter.test(stack);
                boolean positive = InventoryBridgeBlockEntity.this.positiveFilter.test(stack);
                int size1 = handler1.getSlots();
                if (!negative && !positive) {
                    return stack;
                }
                if (negative && !positive && slot >= size1) {
                    return stack;
                }
                if (positive && !negative && slot < size1) {
                    return stack;
                }
                boolean negativeFilterEmpty = InventoryBridgeBlockEntity.this.negativeFilter.getFilter().isEmpty();
                boolean positiveFilterEmpty = InventoryBridgeBlockEntity.this.positiveFilter.getFilter().isEmpty();
                if (!negativeFilterEmpty || !positiveFilterEmpty) {
                    if (slot >= size1 && negative && positiveFilterEmpty) {
                        return stack;
                    }
                    if (slot < size1 && positive && negativeFilterEmpty) {
                        return stack;
                    }
                }
                return slot < size1 ? handler1.insertItem(slot, stack, simulate) : handler2.insertItem(slot - size1, stack, simulate);
            }, stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.preventRecursion(() -> {
                IItemHandler handler1 = InventoryBridgeBlockEntity.this.getNegativeHandler();
                IItemHandler handler2 = InventoryBridgeBlockEntity.this.getPositiveHandler();
                if (handler1 == null && handler2 == null) {
                    return ItemStack.EMPTY;
                }
                if (handler1 == null) {
                    return handler2.extractItem(slot, amount, simulate);
                }
                if (handler2 == null) {
                    return handler1.extractItem(slot, amount, simulate);
                }
                int size1 = handler1.getSlots();
                return slot < size1 ? handler1.extractItem(slot, amount, simulate) : handler2.extractItem(slot - size1, amount, simulate);
            }, ItemStack.EMPTY);
        }

        public int getSlotLimit(int slot) {
            return this.preventRecursion(() -> {
                IItemHandler handler1 = InventoryBridgeBlockEntity.this.getNegativeHandler();
                IItemHandler handler2 = InventoryBridgeBlockEntity.this.getPositiveHandler();
                if (handler1 == null && handler2 == null) {
                    return 0;
                }
                if (handler1 == null) {
                    return handler2.getSlotLimit(slot);
                }
                if (handler2 == null) {
                    return handler1.getSlotLimit(slot);
                }
                int size1 = handler1.getSlots();
                return slot < size1 ? handler1.getSlotLimit(slot) : handler2.getSlotLimit(slot - size1);
            }, 0);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.preventRecursion(() -> {
                IItemHandler handler1 = InventoryBridgeBlockEntity.this.getNegativeHandler();
                IItemHandler handler2 = InventoryBridgeBlockEntity.this.getPositiveHandler();
                if (handler1 == null && handler2 == null) {
                    return false;
                }
                if (handler1 == null) {
                    boolean negative = InventoryBridgeBlockEntity.this.negativeFilter.test(stack);
                    boolean positive = InventoryBridgeBlockEntity.this.positiveFilter.test(stack);
                    if (!positive) {
                        return false;
                    }
                    if (negative && !InventoryBridgeBlockEntity.this.negativeFilter.getFilter().isEmpty() && InventoryBridgeBlockEntity.this.positiveFilter.getFilter().isEmpty()) {
                        return false;
                    }
                    return handler2.isItemValid(slot, stack);
                }
                if (handler2 == null) {
                    boolean negative = InventoryBridgeBlockEntity.this.negativeFilter.test(stack);
                    boolean positive = InventoryBridgeBlockEntity.this.positiveFilter.test(stack);
                    if (!negative) {
                        return false;
                    }
                    if (positive && !InventoryBridgeBlockEntity.this.positiveFilter.getFilter().isEmpty() && InventoryBridgeBlockEntity.this.negativeFilter.getFilter().isEmpty()) {
                        return false;
                    }
                    return handler1.isItemValid(slot, stack);
                }
                boolean negative = InventoryBridgeBlockEntity.this.negativeFilter.test(stack);
                boolean positive = InventoryBridgeBlockEntity.this.positiveFilter.test(stack);
                int size1 = handler1.getSlots();
                if (!negative && !positive) {
                    return false;
                }
                if (negative && !positive && slot >= size1) {
                    return false;
                }
                if (positive && !negative && slot < size1) {
                    return false;
                }
                boolean negativeFilterEmpty = InventoryBridgeBlockEntity.this.negativeFilter.getFilter().isEmpty();
                boolean positiveFilterEmpty = InventoryBridgeBlockEntity.this.positiveFilter.getFilter().isEmpty();
                if (!negativeFilterEmpty || !positiveFilterEmpty) {
                    if (slot >= size1 && negative && positiveFilterEmpty) {
                        return false;
                    }
                    if (slot < size1 && positive && negativeFilterEmpty) {
                        return false;
                    }
                }
                return slot < size1 ? handler1.isItemValid(slot, stack) : handler2.isItemValid(slot - size1, stack);
            }, false);
        }
    }
}

