/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableBiMap;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public enum ScrollWheelHandler implements Consumer<ContainerContext>
{
    ONEITEMIN(-1),
    ONEITEMOUT(1);

    private final int moveAmount;

    private ScrollWheelHandler(int amount) {
        this.moveAmount = amount;
    }

    @Override
    public void accept(ContainerContext context) {
        Slot source;
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        ItemStack is = InventoryHandler.INSTANCE.getItemStack(context);
        if (is == null) {
            return;
        }
        ImmutableBiMap<Container, InventoryHandler.InventoryMapping> mapping = context.mapping;
        if (this.moveAmount < 0 && is.getMaxStackSize() > is.getCount()) {
            source = InventoryHandler.INSTANCE.findStackWithItem(is, context);
        } else if (this.moveAmount > 0) {
            source = context.slot;
        } else {
            return;
        }
        if (source == null) {
            return;
        }
        if (InventorySorter.INSTANCE.isContainerBlacklisted(InventoryHandler.lookupContainerTypeName(context.slotMapping.container))) {
            return;
        }
        if (InventorySorter.INSTANCE.isSlotBlacklisted(source)) {
            return;
        }
        if (InventorySorter.INSTANCE.isSlotBlacklisted(context.slot)) {
            return;
        }
        if (!source.mayPickup((Player)context.player)) {
            return;
        }
        if (!source.mayPlace(is)) {
            return;
        }
        ItemStack sourceStack = InventoryHandler.INSTANCE.getItemStack(source);
        if (sourceStack.isEmpty()) {
            return;
        }
        ItemStack iscopy = sourceStack.copy();
        iscopy.setCount(1);
        ArrayList<InventoryHandler.InventoryMapping> mappingCandidates = new ArrayList<InventoryHandler.InventoryMapping>();
        if (this.moveAmount < 0) {
            InventoryHandler.InventoryMapping inventoryMapping = new InventoryHandler.InventoryMapping(context.slot.container, context.player.containerMenu, context.slot.container, context.slot);
            mappingCandidates.add(inventoryMapping);
            inventoryMapping.begin = context.slot.index;
            inventoryMapping.end = context.slot.index;
        } else if (context.player.containerMenu == context.player.inventoryMenu) {
            if (InventoryHandler.preferredOrders.containsKey(context.slotMapping.inv)) {
                mappingCandidates.addAll(InventoryHandler.preferredOrders.get(context.slotMapping.inv).stream().map(arg_0 -> mapping.get(arg_0)).toList());
            }
            Collections.reverse(mappingCandidates);
        } else {
            for (Map.Entry<Container, InventoryHandler.InventoryMapping> entry : InventoryHandler.INSTANCE.getSortedMapping(context)) {
                if (entry.getValue().proxy == context.slot.container || InventorySorter.INSTANCE.isSlotBlacklisted(entry.getValue().slot)) continue;
                mappingCandidates.add(entry.getValue());
            }
        }
        Collections.reverse(mappingCandidates);
        for (InventoryHandler.InventoryMapping mappingCandidate : mappingCandidates) {
            if (mappingCandidate.inv == ContainerContext.PLAYER_OFFHAND && this.moveAmount > 0) {
                boolean empty = true;
                for (ItemStack itemStack : context.player.getInventory().offhand) {
                    if (itemStack.isEmpty()) continue;
                    empty = false;
                    break;
                }
                if (empty) continue;
            }
            if (mappingCandidate.inv == ContainerContext.PLAYER_HOTBAR && this.moveAmount > 0) {
                boolean hasTarget = false;
                boolean found = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack itemStack = (ItemStack)context.player.getInventory().items.get(i);
                    if (ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)sourceStack) && itemStack.getCount() < itemStack.getMaxStackSize()) {
                        hasTarget = true;
                        continue;
                    }
                    if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)sourceStack)) continue;
                    found = true;
                }
                if (!hasTarget && found) continue;
            }
            InventoryHandler.INSTANCE.moveItemToOtherInventory(context, iscopy, mappingCandidate.begin, mappingCandidate.end + 1, this.moveAmount < 0);
            if (iscopy.getCount() != 0) continue;
            sourceStack.shrink(1);
            source.set(sourceStack);
            break;
        }
    }
}

