/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.platform.services;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public <T extends Block> Supplier<T> registerBlock(String var1, Supplier<T> var2);

    public <T extends Item> Supplier<T> registerItem(String var1, Supplier<T> var2);

    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String var1, Supplier<BlockEntityType<T>> var2);

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BlockEntityFactory<T> var1, Block ... var2);

    public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenuType(String var1, Supplier<MenuType<T>> var2);

    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(MenuFactory<T> var1);

    public <T> Supplier<T> registerCreativeTab(ResourceKey<? extends Registry<T>> var1, String var2, Supplier<T> var3);

    @FunctionalInterface
    public static interface MenuFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2);
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends BlockEntity> {
        public T create(BlockPos var1, BlockState var2);
    }
}

