/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.platform;

import com.leclowndu93150.potion_blending.platform.services.IPlatformHelper;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"potion_blending");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"potion_blending");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"potion_blending");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"potion_blending");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"potion_blending");

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntity(String name, Supplier<BlockEntityType<T>> blockEntity) {
        return BLOCK_ENTITIES.register(name, blockEntity);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(IPlatformHelper.BlockEntityFactory<T> factory, Block ... blocks) {
        return new BlockEntityType(factory::create, Set.of(blocks), null);
    }

    @Override
    public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenuType(String name, Supplier<MenuType<T>> menuType) {
        return MENU_TYPES.register(name, menuType);
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(IPlatformHelper.MenuFactory<T> factory) {
        return new MenuType(factory::create, FeatureFlags.DEFAULT_FLAGS);
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    @Override
    public <T> Supplier<T> registerCreativeTab(ResourceKey<? extends Registry<T>> registry, String name, Supplier<T> tab) {
        if (registry.equals((Object)Registries.CREATIVE_MODE_TAB)) {
            return CREATIVE_TABS.register(name, tab);
        }
        throw new IllegalArgumentException("Unsupported registry: " + String.valueOf(registry));
    }
}

