/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.client.renderer;

import com.leclowndu93150.potion_blending.block.entity.PotionBlendingStandBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import org.joml.Matrix4f;

public class PotionBlendingStandRenderer
implements BlockEntityRenderer<PotionBlendingStandBlockEntity> {
    private static final ResourceLocation GEM_0 = ResourceLocation.fromNamespaceAndPath((String)"potion_blending", (String)"block/crucible_potion_0");
    private static final ResourceLocation GEM_1 = ResourceLocation.fromNamespaceAndPath((String)"potion_blending", (String)"block/crucible_potion_1");
    private static final ResourceLocation GEM_2 = ResourceLocation.fromNamespaceAndPath((String)"potion_blending", (String)"block/crucible_potion_2");
    private static final ResourceLocation GEM_OUTPUT = ResourceLocation.fromNamespaceAndPath((String)"potion_blending", (String)"block/crucible_potion_output");

    public PotionBlendingStandRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PotionBlendingStandBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        this.renderGems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
        if (blockEntity.isBrewing() && blockEntity.getLevel() != null && blockEntity.getLevel().getRandom().nextFloat() < 0.3f) {
            RandomSource random = blockEntity.getLevel().getRandom();
            int potionCount = blockEntity.getPotionCount();
            double baseY = (double)blockEntity.getBlockPos().getY() + 0.25;
            double fluidHeight = 0.0625 * (double)potionCount * 2.0;
            double x = (double)blockEntity.getBlockPos().getX() + 0.5 + (random.nextDouble() - 0.5) * 0.3;
            double y = baseY + fluidHeight + 0.1;
            double z = (double)blockEntity.getBlockPos().getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.3;
            blockEntity.getLevel().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, 0.0, 0.07, 0.0);
        }
    }

    private void renderGems(PotionBlendingStandBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderGemOverlay(blockEntity, 0, GEM_0, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderGemOverlay(blockEntity, 1, GEM_1, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderGemOverlay(blockEntity, 2, GEM_2, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderGemOverlay(blockEntity, 4, GEM_OUTPUT, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderGemOverlay(PotionBlendingStandBlockEntity blockEntity, int slot, ResourceLocation gemTexture, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.getItem(slot);
        if (!this.isPotion(stack)) {
            return;
        }
        PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (contents == null) {
            return;
        }
        int color = contents.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(gemTexture);
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        Matrix4f matrix = poseStack.last().pose();
        float offset = 0.001f;
        this.renderFaceNorth(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
        this.renderFaceSouth(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
        this.renderFaceEast(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
        this.renderFaceWest(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
    }

    private void renderFaceNorth(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        consumer.addVertex(matrix, 0.0f, 1.0f, 0.0f - offset).setColor(r, g, b, 1.0f).setUv(minU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(matrix, 1.0f, 1.0f, 0.0f - offset).setColor(r, g, b, 1.0f).setUv(maxU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(matrix, 1.0f, 0.0f, 0.0f - offset).setColor(r, g, b, 1.0f).setUv(maxU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
        consumer.addVertex(matrix, 0.0f, 0.0f, 0.0f - offset).setColor(r, g, b, 1.0f).setUv(minU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void renderFaceSouth(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        consumer.addVertex(matrix, 1.0f, 0.0f, 1.0f + offset).setColor(r, g, b, 1.0f).setUv(minU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix, 1.0f, 1.0f, 1.0f + offset).setColor(r, g, b, 1.0f).setUv(minU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix, 0.0f, 1.0f, 1.0f + offset).setColor(r, g, b, 1.0f).setUv(maxU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
        consumer.addVertex(matrix, 0.0f, 0.0f, 1.0f + offset).setColor(r, g, b, 1.0f).setUv(maxU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(0.0f, 0.0f, 1.0f);
    }

    private void renderFaceEast(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        consumer.addVertex(matrix, 1.0f + offset, 0.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(maxU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 1.0f + offset, 1.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(maxU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 1.0f + offset, 1.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(minU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 1.0f + offset, 0.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(minU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    private void renderFaceWest(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        consumer.addVertex(matrix, 0.0f - offset, 0.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(minU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 0.0f - offset, 0.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(maxU, maxV).setOverlay(packedOverlay).setLight(packedLight).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 0.0f - offset, 1.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(maxU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(-1.0f, 0.0f, 0.0f);
        consumer.addVertex(matrix, 0.0f - offset, 1.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(minU, minV).setOverlay(packedOverlay).setLight(packedLight).setNormal(-1.0f, 0.0f, 0.0f);
    }

    private boolean isPotion(ItemStack stack) {
        return stack.is(Items.POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.LINGERING_POTION);
    }

    public int getViewDistance() {
        return 256;
    }
}

