/*
 * Decompiled with CFR 0.152.
 */
package waves.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import waves.client.ClientEventHandler;
import waves.client.ClientHelpers;
import waves.client.particle.WaveParticle;
import waves.util.RenderHelpers;
import waves.util.WaveHelpers;

public class WaveParticleHandler
extends TextureSheetParticle {
    public final Tesselator tesselator;
    public final ResourceKey<Level> dimensionKey;
    public List<WaveParticle> cachedWaveParticles = new CopyOnWriteArrayList<WaveParticle>();

    public WaveParticleHandler(ClientLevel level) {
        super(level, 0.0, 0.0, 0.0);
        this.tesselator = Tesselator.getInstance();
        this.setBoundingBox(WaveHelpers.INFINITE_EXTENT_AABB);
        this.lifetime = Integer.MAX_VALUE;
        this.gravity = 0.0f;
        this.alpha = 0.0f;
        this.hasPhysics = false;
        this.dimensionKey = level.dimension();
    }

    public void tick() {
        List waveList = (List)ClientEventHandler.WAVE_PARTICLES.get(this.dimensionKey);
        if (waveList != null && !waveList.isEmpty()) {
            Minecraft mc = ClientEventHandler.mc;
            LocalPlayer player = mc.player;
            Vec3 eyePos = player.getEyePosition(ClientEventHandler.partialTicks);
            Vec3 lookVec = player.getLookAngle();
            double offsetDistance = 2.0;
            Vec3 offsetPos = eyePos.add(lookVec.scale(offsetDistance));
            this.setPos(offsetPos.x(), offsetPos.y(), offsetPos.z());
            this.cachedWaveParticles.clear();
            this.cachedWaveParticles.addAll(waveList);
            float partialTicks = ClientEventHandler.partialTicks;
            this.cachedWaveParticles.parallelStream().forEach(arg_0 -> WaveParticleHandler.lambda$tick$0((Player)player, partialTicks, arg_0));
        }
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        if (this.cachedWaveParticles != null && !this.cachedWaveParticles.isEmpty()) {
            Vec3 cameraPos = camera.getPosition();
            this.cachedWaveParticles.stream().forEach(wave -> {
                if (wave != null && wave.shouldRender()) {
                    this.renderWave((WaveParticle)wave, buffer, cameraPos, partialTicks);
                }
            });
        }
    }

    public void renderWave(WaveParticle wave, VertexConsumer buffer, Vec3 cameraPos, float partialTicks) {
        int i;
        PoseStack poseStack = new PoseStack();
        Matrix4f matrix = poseStack.last().pose();
        BufferBuilder builder = this.tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
        RenderHelpers.translucentTransparency();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)wave.waveTexture);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        poseStack.pushPose();
        float x = (float)(Mth.lerp((double)partialTicks, (double)wave.xo, (double)wave.x) - cameraPos.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)wave.yo, (double)wave.y) - cameraPos.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)wave.zo, (double)wave.z) - cameraPos.z());
        Vector3f[] quad = (Vector3f[])Arrays.stream(ClientHelpers.QUAD).map(Vector3f::new).toArray(Vector3f[]::new);
        for (i = 0; i < 4; ++i) {
            Vector3f vector3 = quad[i];
            vector3.rotate((Quaternionfc)wave.rotation);
            vector3.mul(wave.quadSize);
            vector3.add(x, y, z);
        }
        for (i = 0; i < 4; ++i) {
            RenderHelpers.drawVertex((VertexConsumer)builder, poseStack, matrix, quad[i], wave.color, ClientHelpers.UVS[i], wave.packedLight);
        }
        poseStack.popPose();
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    private static /* synthetic */ void lambda$tick$0(Player player, float partialTicks, WaveParticle wave) {
        if (wave != null) {
            wave.tick(player, partialTicks);
        }
    }
}

