/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.network.CreativePacket;

public class OpenGuiPacket
extends CreativePacket {
    public String name;
    public CompoundTag nbt;

    public OpenGuiPacket() {
    }

    public OpenGuiPacket(String name, CompoundTag nbt) {
        this.name = name;
        this.nbt = nbt;
    }

    @Override
    public void executeClient(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IGuiIntegratedParent) {
            IGuiIntegratedParent gui = (IGuiIntegratedParent)abstractContainerMenu;
            gui.openLayer(GuiCreator.REGISTRY.get((String)this.name).function.apply(this.nbt, player));
        }
    }

    @Override
    public void executeServer(ServerPlayer player) {
        OpenGuiPacket.openGuiOnServer(GuiCreator.REGISTRY.get(this.name), this.nbt, player);
    }

    public static void openGuiOnServer(GuiCreator creator, CompoundTag nbt, ServerPlayer player) {
        GuiLayer layer = creator.function.apply(nbt, (Player)player);
        if (layer == null) {
            return;
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, x) -> new ContainerIntegration(CreativeCore.GUI_CONTAINER, id, x, layer), (Component)Component.literal((String)creator.getName())));
        CreativeCore.NETWORK.sendToClient((CreativePacket)new OpenGuiPacket(creator.getName(), nbt), player);
        layer.init();
    }
}

