/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.golden_foods.core.registry;

import java.util.function.Supplier;
import neoforge.com.cursee.golden_foods.core.registry.ModBlocksNeoForge;
import neoforge.com.cursee.golden_foods.core.registry.ModItemsNeoForge;
import neoforge.com.cursee.golden_foods.core.registry.ModTabsNeoForge;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RegistryNeoForge {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"golden_foods");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"golden_foods");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.key(), (String)"golden_foods");

    public static void register(IEventBus modEventBus) {
        ModBlocksNeoForge.register();
        ModItemsNeoForge.register();
        ModTabsNeoForge.register();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TABS.register(modEventBus);
    }

    public static <T extends Block> DeferredHolder<Block, T> registerBlock(String blockID, Supplier<T> blockSupplier) {
        return BLOCKS.register(blockID, blockSupplier);
    }

    public static <T extends Item> DeferredHolder<Item, T> registerItem(String itemID, Supplier<T> itemSupplier) {
        return ITEMS.register(itemID, itemSupplier);
    }

    public static <T extends Block> DeferredHolder<Block, T> registerBlockWithItem(String blockID, Supplier<T> blockSupplier) {
        DeferredHolder toReturn = RegistryNeoForge.registerBlock(blockID, blockSupplier);
        RegistryNeoForge.registerItem(blockID, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static <T extends CreativeModeTab> DeferredHolder<CreativeModeTab, T> registerTab(String tabID, Supplier<T> tabSupplier) {
        return TABS.register(tabID, tabSupplier);
    }
}

