/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.golden_foods.core.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class GoldenCakeBlock
extends CakeBlock {
    public GoldenCakeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE));
    }

    protected ItemInteractionResult useItemOn(ItemStack $$0, BlockState $$1, Level $$2, BlockPos $$3, Player $$4, InteractionHand $$5, BlockHitResult $$6) {
        Block var10;
        Item $$7 = $$0.getItem();
        if ($$0.is(ItemTags.CANDLES) && (Integer)$$1.getValue((Property)BITES) == 0 && (var10 = Block.byItem((Item)$$7)) instanceof CandleBlock) {
            CandleBlock $$9 = (CandleBlock)var10;
            $$0.consume(1, (LivingEntity)$$4);
            $$2.playSound((Player)null, $$3, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            $$2.setBlockAndUpdate($$3, CandleCakeBlock.byCandle((CandleBlock)$$9));
            $$2.gameEvent((Entity)$$4, (Holder)GameEvent.BLOCK_CHANGE, $$3);
            $$4.awardStat(Stats.ITEM_USED.get((Object)$$7));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState $$0, Level $$1, BlockPos $$2, Player $$3, BlockHitResult $$4) {
        if ($$1.isClientSide) {
            if (GoldenCakeBlock.eat((LevelAccessor)$$1, $$2, $$0, $$3).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if ($$3.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return GoldenCakeBlock.eat((LevelAccessor)$$1, $$2, $$0, $$3);
    }

    @NotNull
    protected static InteractionResult eat(LevelAccessor levelAccessor, @NotNull BlockPos blockPos, BlockState blockState, Player player) {
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(4, 1.2f);
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 1));
        int currentBites = (Integer)blockState.getValue((Property)BITES);
        levelAccessor.gameEvent((Entity)player, (Holder)GameEvent.EAT, blockPos);
        if (currentBites < 6) {
            levelAccessor.setBlock(blockPos, (BlockState)blockState.setValue((Property)BITES, (Comparable)Integer.valueOf(currentBites + 1)), 3);
        } else {
            levelAccessor.removeBlock(blockPos, false);
            levelAccessor.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, blockPos);
        }
        return InteractionResult.SUCCESS;
    }
}

