/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.common.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import tallestegg.guardvillagers.GuardDataAttachments;
import tallestegg.guardvillagers.common.entities.ai.tasks.VillagerHelp;
import tallestegg.guardvillagers.configuration.GuardConfig;

public class RepairGolem
extends VillagerHelp {
    private LivingEntity golem;

    public RepairGolem() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT), (List)GuardConfig.COMMON.professionsThatRepairGolems.get());
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, Villager owner) {
        List list = (List)owner.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).get();
        if (!list.isEmpty()) {
            for (LivingEntity golem : list) {
                if (golem.isInvisible() || !golem.isAlive() || golem.getType() != EntityType.IRON_GOLEM || !(golem.getHealth() <= golem.getMaxHealth() * 0.75f)) continue;
                this.golem = golem;
                return super.checkExtraStartConditions(worldIn, owner);
            }
        }
        return false;
    }

    @Override
    protected long timeToCheck(LivingEntity owner) {
        return (Long)owner.getData(GuardDataAttachments.LAST_REPAIRED_GOLEM);
    }

    protected boolean canStillUse(ServerLevel level, Villager entity, long gameTime) {
        return (Integer)entity.getData(GuardDataAttachments.TIMES_HEALED_GOLEM) < (Integer)GuardConfig.COMMON.maxGolemRepair.get() && this.golem.getHealth() <= this.golem.getMaxHealth();
    }

    protected void stop(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if ((Integer)entityIn.getData(GuardDataAttachments.TIMES_HEALED_GOLEM) >= (Integer)GuardConfig.COMMON.maxGolemRepair.get()) {
            entityIn.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            entityIn.setData(GuardDataAttachments.LAST_REPAIRED_GOLEM.get(), (Object)worldIn.getDayTime());
            entityIn.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            entityIn.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
            entityIn.setData(GuardDataAttachments.TIMES_HEALED_GOLEM.get(), (Object)0);
        }
    }

    protected void start(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (this.golem == null) {
            return;
        }
    }

    protected void tick(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        this.healGolem(entityIn);
    }

    public void healGolem(Villager healer) {
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)healer, (Entity)this.golem, (float)0.5f, (int)0);
        if ((double)healer.distanceTo((Entity)this.golem) <= 2.0) {
            healer.setData(GuardDataAttachments.TIMES_HEALED_GOLEM.get(), (Object)((Integer)healer.getData(GuardDataAttachments.TIMES_HEALED_GOLEM.get()) + 1));
            healer.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_INGOT));
            healer.swing(InteractionHand.MAIN_HAND);
            this.golem.heal(15.0f);
            float pitch = 1.0f + (this.golem.getRandom().nextFloat() - this.golem.getRandom().nextFloat()) * 0.2f;
            this.golem.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, pitch);
        }
    }
}

