/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.models;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import tallestegg.guardvillagers.common.entities.Guard;

public class GuardSteveModel
extends PlayerModel<Guard> {
    public GuardSteveModel(ModelPart part) {
        super(part, false);
    }

    public void setupAnim(Guard entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netbipedHeadYaw, float bipedHeadPitch) {
        super.setupAnim((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netbipedHeadYaw, bipedHeadPitch);
        if (entityIn.getKickTicks() > 0) {
            float f1 = 1.0f - (float)Mth.abs((int)(10 - 2 * entityIn.getKickTicks())) / 10.0f;
            this.rightLeg.xRot = Mth.lerp((float)f1, (float)this.rightLeg.xRot, (float)-1.4f);
        }
        ItemStack itemstack = entityIn.getItemInHand(InteractionHand.MAIN_HAND);
        boolean isHoldingShootable = itemstack.getItem() instanceof ProjectileWeaponItem;
        double speed = 0.005;
        if (this.attackTime == 0.0f && entityIn.isAggressive() && !isHoldingShootable && entityIn.getDeltaMovement().horizontalDistanceSqr() > speed && !entityIn.getMainHandItem().isEmpty() && !entityIn.isBlocking()) {
            AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, (Mob)entityIn, (float)this.attackTime, (float)ageInTicks);
        }
        if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
            this.eatingAnimationRightHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
        } else {
            this.eatingAnimationRightHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)false);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void eatingAnimationRightHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.getItemInHand(hand);
        boolean bl = drinkingoreating = itemstack.getUseAnimation() == UseAnim.EAT || itemstack.getUseAnimation() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.rightArm.yRot = -0.5f;
            this.rightArm.xRot = -1.3f;
            this.rightArm.zRot = Mth.cos((float)ageInTicks) * 0.1f;
            this.head.xRot = Mth.cos((float)ageInTicks) * 0.2f;
            this.head.yRot = 0.0f;
            this.hat.copyFrom(this.head);
        }
    }

    public void eatingAnimationLeftHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.getItemInHand(hand);
        boolean bl = drinkingoreating = itemstack.getUseAnimation() == UseAnim.EAT || itemstack.getUseAnimation() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.leftArm.yRot = 0.5f;
            this.leftArm.xRot = -1.3f;
            this.leftArm.zRot = Mth.cos((float)ageInTicks) * 0.1f;
            this.head.xRot = Mth.cos((float)ageInTicks) * 0.2f;
            this.head.yRot = 0.0f;
            this.hat.copyFrom(this.head);
        }
    }
}

