/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.block.hopper;

import net.caffeinemc.mods.lithium.common.block.entity.ShapeUpdateHandlingBlockBehaviour;
import net.caffeinemc.mods.lithium.common.hopper.UpdateReceiver;
import net.caffeinemc.mods.lithium.common.world.blockentity.BlockEntityGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HopperBlock.class})
public abstract class HopperBlockMixin
extends BaseEntityBlock
implements ShapeUpdateHandlingBlockBehaviour {
    protected HopperBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public void lithium$handleShapeUpdate(LevelReader levelReader, BlockState myBlockState, BlockPos myPos, BlockPos posFrom, BlockState newState) {
        if (!levelReader.isClientSide() && newState.getBlock() instanceof WorldlyContainerHolder) {
            this.updateHopper(levelReader, myBlockState, myPos, posFrom);
        }
    }

    @Inject(method={"neighborChanged"}, at={@At(value="HEAD")})
    private void updateBlockEntity(BlockState blockState, Level world, BlockPos myPos, Block block, BlockPos blockPos2, boolean bl, CallbackInfo ci) {
        BlockEntity hopper;
        if (!world.isClientSide() && (hopper = ((BlockEntityGetter)world).lithium$getLoadedExistingBlockEntity(myPos)) instanceof UpdateReceiver) {
            UpdateReceiver updateReceiver = (UpdateReceiver)hopper;
            updateReceiver.lithium$invalidateCacheOnUndirectedNeighborUpdate();
        }
    }

    private void updateHopper(LevelReader world, BlockState myBlockState, BlockPos myPos, BlockPos posFrom) {
        BlockEntity hopper;
        boolean above;
        Direction facing = (Direction)myBlockState.getValue((Property)HopperBlock.FACING);
        boolean bl = above = posFrom.getY() == myPos.getY() + 1;
        if ((above || posFrom.getX() == myPos.getX() + facing.getStepX() && posFrom.getY() == myPos.getY() + facing.getStepY() && posFrom.getZ() == myPos.getZ() + facing.getStepZ()) && (hopper = ((BlockEntityGetter)world).lithium$getLoadedExistingBlockEntity(myPos)) instanceof UpdateReceiver) {
            UpdateReceiver updateReceiver = (UpdateReceiver)hopper;
            updateReceiver.lithium$invalidateCacheOnNeighborUpdate(above);
        }
    }

    @Inject(method={"onPlace"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/HopperBlock;checkPoweredState(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", shift=At.Shift.AFTER)})
    private void workAroundVanillaUpdateSuppression(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify, CallbackInfo ci) {
        if (world.getBlockState(pos) != state) {
            for (Direction direction : UPDATE_SHAPE_ORDER) {
                BlockEntity hopper = ((BlockEntityGetter)world).lithium$getLoadedExistingBlockEntity(pos.relative(direction));
                if (!(hopper instanceof UpdateReceiver)) continue;
                UpdateReceiver updateReceiver = (UpdateReceiver)hopper;
                updateReceiver.lithium$invalidateCacheOnNeighborUpdate(direction == Direction.DOWN);
            }
        }
    }
}

