/*
 * Decompiled with CFR 0.152.
 */
package com.zv;

import com.zv.ModEntities;
import com.zv.ModTags;
import com.zv.ServerState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.chunk.ChunkAccess;

public class Utils {
    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"zombie_variants", (String)path);
    }

    public static EntityType<?> tryReplaceZombie(ServerLevel world, EntityType<?> type, MobCategory group, BlockPos pos, ChunkAccess chunk) {
        ServerState serverState = ServerState.get(world.getServer());
        Holder biomeHolder = world.getBiome(pos);
        if (biomeHolder.is(ModTags.SPAWNS_DESERT_ZOMBIES) && world == world.getServer().overworld()) {
            for (BlockPos blockPos : serverState.pyramidLocations.keySet()) {
                if (!blockPos.closerThan((Vec3i)pos, 40.0)) continue;
                return (EntityType)ModEntities.DESERT_ZOMBIE.get();
            }
            if (type == EntityType.ZOMBIE) {
                return EntityType.HUSK;
            }
        }
        if (type != EntityType.ZOMBIE) {
            return type;
        }
        if (biomeHolder.is(ModTags.SPAWNS_DEEP_DARK_ZOMBIES)) {
            return (EntityType)ModEntities.DEEP_DARK_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_DRIPSTONE_ZOMBIES)) {
            return (EntityType)ModEntities.DRIPSTONE_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_LUSH_ZOMBIES)) {
            return (EntityType)ModEntities.LUSH_ZOMBIE.get();
        }
        if (pos.getY() < world.getSeaLevel() - 50) {
            return (EntityType)ModEntities.CAVE_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_BADLANDS_ZOMBIES)) {
            return (EntityType)ModEntities.BADLANDS_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_BAMBOO_ZOMBIES)) {
            return (EntityType)ModEntities.BAMBOO_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_CHERRY_ZOMBIES)) {
            return (EntityType)ModEntities.CHERRY_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_FROZEN_ZOMBIES)) {
            return (EntityType)ModEntities.FROZEN_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_JUNGLE_ZOMBIES)) {
            return (EntityType)ModEntities.JUNGLE_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_MANGROVE_ZOMBIES)) {
            return (EntityType)ModEntities.MANGROVE_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_PALE_GARDEN_ZOMBIES)) {
            return (EntityType)ModEntities.PALE_GARDEN_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_SAVANNA_ZOMBIES)) {
            return (EntityType)ModEntities.SAVANNA_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_SWAMP_ZOMBIES)) {
            return (EntityType)ModEntities.SWAMP_ZOMBIE.get();
        }
        if (biomeHolder.is(ModTags.SPAWNS_MUSHROOM_ZOMBIES)) {
            return (EntityType)ModEntities.MUSHROOM_ZOMBIE.get();
        }
        return type;
    }
}

