/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.ender_pack.client;

import com.cursee.monolib.util.toml.Toml;
import forge.com.cursee.ender_pack.client.ClientConfiguredValues;
import forge.com.cursee.ender_pack.platform.Services;
import java.io.File;
import java.io.PrintWriter;

public class ForgeClientConfigHandler {
    public static void onLoad() {
        File configDir = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
        configDir.mkdirs();
        File configFile = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + "ender_pack-client.toml");
        if (configFile.exists()) {
            ForgeClientConfigHandler.read(configFile);
        } else {
            ForgeClientConfigHandler.write(configFile);
        }
    }

    static void read(File file) {
        Toml toml = new Toml().read(file);
        ClientConfiguredValues.RENDERS_IN_ARMOR_SLOT = toml.getBoolean("renders_in_armor_slot");
        ClientConfiguredValues.RENDERS_IN_EXTRA_SLOT = toml.getBoolean("renders_in_extra_slot");
    }

    static void write(File file) {
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println("# setting to false disables rendering from chestplate slot");
            writer.println("renders_in_armor_slot = true");
            writer.println();
            writer.println("# setting to false disables rendering from curios/trinkets slot");
            writer.println("renders_in_extra_slot = true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

